/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ScheduledThreadPoolAdd;
import org.jboss.as.threads.ScheduledThreadPoolMetricsHandler;
import org.jboss.as.threads.ScheduledThreadPoolRemove;
import org.jboss.as.threads.ScheduledThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolResourceDescriptionResolver;
import org.jboss.as.threads.ThreadsExtension;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolResourceDefinition
extends SimpleResourceDefinition {
    private final boolean registerRuntimeOnly;
    private final ServiceName serviceNameBase;

    public static ScheduledThreadPoolResourceDefinition create(boolean registerRuntimeOnly) {
        return ScheduledThreadPoolResourceDefinition.create("scheduled-thread-pool", ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static ScheduledThreadPoolResourceDefinition create(String type, ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase, boolean registerRuntimeOnly) {
        ScheduledThreadPoolAdd addHandler = new ScheduledThreadPoolAdd(threadFactoryResolver, serviceNameBase);
        return new ScheduledThreadPoolResourceDefinition(type, addHandler, serviceNameBase, registerRuntimeOnly);
    }

    private ScheduledThreadPoolResourceDefinition(String type, ScheduledThreadPoolAdd addHandler, ServiceName serviceNameBase, boolean registerRuntimeOnly) {
        super(PathElement.pathElement((String)type), (ResourceDescriptionResolver)new ThreadPoolResourceDescriptionResolver("scheduled-thread-pool", ThreadsExtension.RESOURCE_NAME, ThreadsExtension.class.getClassLoader()), (AbstractAddStepHandler)addHandler, (OperationStepHandler)new ScheduledThreadPoolRemove(addHandler));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.serviceNameBase = serviceNameBase;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, null);
        new ScheduledThreadPoolWriteAttributeHandler(this.serviceNameBase).registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            new ScheduledThreadPoolMetricsHandler(this.serviceNameBase).registerAttributes(resourceRegistration);
        }
    }
}

