/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDateFormat;
import org.jboss.netty.handler.codec.http.DefaultCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieDecoder {
    private static final Pattern PATTERN = Pattern.compile("(?:\\s|[;,])*\\$*([^;=]+)(?:=(?:[\"']((?:\\\\.|[^\"])*)[\"']|([^;,]*)))?(\\s*(?:[;,]+\\s*|$))");
    private static final String COMMA = ",";
    private final boolean lenient;

    public CookieDecoder() {
        this(false);
    }

    public CookieDecoder(boolean lenient) {
        this.lenient = lenient;
    }

    public Set<Cookie> decode(String header) {
        int i;
        ArrayList<String> names = new ArrayList<String>(8);
        ArrayList<String> values = new ArrayList<String>(8);
        this.extractKeyValuePairs(header, names, values);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        int version = 0;
        if (((String)names.get(0)).equalsIgnoreCase("Version")) {
            try {
                version = Integer.parseInt((String)values.get(0));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            i = 1;
        } else {
            i = 0;
        }
        if (names.size() <= i) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> cookies = new TreeSet<Cookie>();
        while (i < names.size()) {
            String name = (String)names.get(i);
            if (!this.lenient || !"HTTPOnly".equalsIgnoreCase(name)) {
                String value = (String)values.get(i);
                if (value == null) {
                    value = "";
                }
                DefaultCookie c = new DefaultCookie(name, value);
                cookies.add(c);
                boolean discard = false;
                boolean secure = false;
                boolean httpOnly = false;
                String comment = null;
                String commentURL = null;
                String domain = null;
                String path = null;
                int maxAge = -1;
                ArrayList<Integer> ports = new ArrayList<Integer>(2);
                int j = i + 1;
                while (j < names.size()) {
                    block38: {
                        name = (String)names.get(j);
                        value = (String)values.get(j);
                        if ("Discard".equalsIgnoreCase(name)) {
                            discard = true;
                        } else if ("Secure".equalsIgnoreCase(name)) {
                            secure = true;
                        } else if ("HTTPOnly".equalsIgnoreCase(name)) {
                            httpOnly = true;
                        } else if ("Comment".equalsIgnoreCase(name)) {
                            comment = value;
                        } else if ("CommentURL".equalsIgnoreCase(name)) {
                            commentURL = value;
                        } else if ("Domain".equalsIgnoreCase(name)) {
                            domain = value;
                        } else if ("Path".equalsIgnoreCase(name)) {
                            path = value;
                        } else if ("Expires".equalsIgnoreCase(name)) {
                            try {
                                long maxAgeMillis = new CookieDateFormat().parse(value).getTime() - System.currentTimeMillis();
                                if (maxAgeMillis <= 0L) {
                                    maxAge = 0;
                                    break block38;
                                }
                                maxAge = (int)(maxAgeMillis / 1000L) + (maxAgeMillis % 1000L != 0L ? 1 : 0);
                            }
                            catch (ParseException e) {}
                        } else if ("Max-Age".equalsIgnoreCase(name)) {
                            maxAge = Integer.parseInt(value);
                        } else if ("Version".equalsIgnoreCase(name)) {
                            version = Integer.parseInt(value);
                        } else {
                            String[] portList;
                            if (!"Port".equalsIgnoreCase(name)) break;
                            for (String s1 : portList = value.split(COMMA)) {
                                try {
                                    ports.add(Integer.valueOf(s1));
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++j;
                    ++i;
                }
                c.setVersion(version);
                c.setMaxAge(maxAge);
                c.setPath(path);
                c.setDomain(domain);
                c.setSecure(secure);
                c.setHttpOnly(httpOnly);
                if (version > 0) {
                    c.setComment(comment);
                }
                if (version > 1) {
                    c.setCommentUrl(commentURL);
                    c.setPorts(ports);
                    c.setDiscard(discard);
                }
            }
            ++i;
        }
        return cookies;
    }

    private void extractKeyValuePairs(String header, List<String> names, List<String> values) {
        Matcher m = PATTERN.matcher(header);
        int pos = 0;
        String name = null;
        String value = null;
        String separator = null;
        while (m.find(pos)) {
            pos = m.end();
            String newName = m.group(1);
            String newValue = m.group(3);
            if (newValue == null) {
                newValue = this.decodeValue(m.group(2));
            }
            String newSeparator = m.group(4);
            if (name == null) {
                name = newName;
                value = newValue == null ? "" : newValue;
                separator = newSeparator;
                continue;
            }
            if (!(newValue != null || "Discard".equalsIgnoreCase(newName) || "Secure".equalsIgnoreCase(newName) || "HTTPOnly".equalsIgnoreCase(newName))) {
                value = value + separator + newName;
                separator = newSeparator;
                continue;
            }
            names.add(name);
            values.add(value);
            name = newName;
            value = newValue;
            separator = newSeparator;
        }
        if (name != null) {
            names.add(name);
            values.add(value);
        }
    }

    private String decodeValue(String value) {
        if (value == null) {
            return value;
        }
        return value.replace("\\\"", "\"").replace("\\\\", "\\");
    }
}

