/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.nio.ByteOrder;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.SpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlock;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockCompressor;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.SpdyNoOpFrame;
import org.jboss.netty.handler.codec.spdy.SpdyPingFrame;
import org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;

public class SpdyFrameEncoder
extends OneToOneEncoder {
    private volatile boolean finished;
    private final SpdyHeaderBlockCompressor headerBlockCompressor;

    public SpdyFrameEncoder() {
        this(6, 15, 8);
    }

    public SpdyFrameEncoder(int compressionLevel, int windowBits, int memLevel) {
        this.headerBlockCompressor = SpdyHeaderBlockCompressor.newInstance(compressionLevel, windowBits, memLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (evt instanceof ChannelStateEvent) {
            ChannelStateEvent e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    SpdyHeaderBlockCompressor spdyHeaderBlockCompressor = this.headerBlockCompressor;
                    synchronized (spdyHeaderBlockCompressor) {
                        this.finished = true;
                        this.headerBlockCompressor.end();
                        break;
                    }
                }
            }
        }
        super.handleDownstream(ctx, evt);
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            ChannelBuffer data = spdyDataFrame.getData();
            int flags = spdyDataFrame.isLast() ? 1 : 0;
            ChannelBuffer header = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8);
            header.writeInt(spdyDataFrame.getStreamID() & Integer.MAX_VALUE);
            header.writeByte(flags);
            header.writeMedium(data.readableBytes());
            return ChannelBuffers.wrappedBuffer(header, data);
        }
        if (msg instanceof SpdySynStreamFrame) {
            int headerBlockLength;
            int flags;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            ChannelBuffer data = this.compressHeaderBlock(this.encodeHeaderBlock(spdySynStreamFrame));
            int n = flags = spdySynStreamFrame.isLast() ? 1 : 0;
            if (spdySynStreamFrame.isUnidirectional()) {
                flags = (byte)(flags | 2);
            }
            int length = (headerBlockLength = data.readableBytes()) == 0 ? 12 : 10 + headerBlockLength;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
            frame.writeShort(32770);
            frame.writeShort(1);
            frame.writeByte(flags);
            frame.writeMedium(length);
            frame.writeInt(spdySynStreamFrame.getStreamID());
            frame.writeInt(spdySynStreamFrame.getAssociatedToStreamID());
            frame.writeShort((short)spdySynStreamFrame.getPriority() << 14);
            if (data.readableBytes() == 0) {
                frame.writeShort(0);
            }
            return ChannelBuffers.wrappedBuffer(frame, data);
        }
        if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            ChannelBuffer data = this.compressHeaderBlock(this.encodeHeaderBlock(spdySynReplyFrame));
            int flags = spdySynReplyFrame.isLast() ? 1 : 0;
            int headerBlockLength = data.readableBytes();
            int length = headerBlockLength == 0 ? 8 : 6 + headerBlockLength;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
            frame.writeShort(32770);
            frame.writeShort(2);
            frame.writeByte(flags);
            frame.writeMedium(length);
            frame.writeInt(spdySynReplyFrame.getStreamID());
            if (data.readableBytes() == 0) {
                frame.writeInt(0);
            } else {
                frame.writeShort(0);
            }
            return ChannelBuffers.wrappedBuffer(frame, data);
        }
        if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 16);
            frame.writeShort(32770);
            frame.writeShort(3);
            frame.writeInt(8);
            frame.writeInt(spdyRstStreamFrame.getStreamID());
            frame.writeInt(spdyRstStreamFrame.getStatus().getCode());
            return frame;
        }
        if (msg instanceof SpdySettingsFrame) {
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int flags = spdySettingsFrame.clearPreviouslyPersistedSettings() ? 1 : 0;
            Set<Integer> IDs = spdySettingsFrame.getIDs();
            int numEntries = IDs.size();
            int length = 4 + numEntries * 8;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
            frame.writeShort(32770);
            frame.writeShort(4);
            frame.writeByte(flags);
            frame.writeMedium(length);
            frame.writeInt(numEntries);
            for (Integer ID : IDs) {
                int id = ID;
                byte ID_flags = 0;
                if (spdySettingsFrame.persistValue(id)) {
                    ID_flags = (byte)(ID_flags | 1);
                }
                if (spdySettingsFrame.isPersisted(id)) {
                    ID_flags = (byte)(ID_flags | 2);
                }
                frame.writeByte(id >> 0 & 0xFF);
                frame.writeByte(id >> 8 & 0xFF);
                frame.writeByte(id >> 16 & 0xFF);
                frame.writeByte(ID_flags);
                frame.writeInt(spdySettingsFrame.getValue(id));
            }
            return frame;
        }
        if (msg instanceof SpdyNoOpFrame) {
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8);
            frame.writeShort(32770);
            frame.writeShort(5);
            frame.writeInt(0);
            return frame;
        }
        if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 12);
            frame.writeShort(32770);
            frame.writeShort(6);
            frame.writeInt(4);
            frame.writeInt(spdyPingFrame.getID());
            return frame;
        }
        if (msg instanceof SpdyGoAwayFrame) {
            SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)msg;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 12);
            frame.writeShort(32770);
            frame.writeShort(7);
            frame.writeInt(4);
            frame.writeInt(spdyGoAwayFrame.getLastGoodStreamID());
            return frame;
        }
        if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            ChannelBuffer data = this.compressHeaderBlock(this.encodeHeaderBlock(spdyHeadersFrame));
            int headerBlockLength = data.readableBytes();
            int length = headerBlockLength == 0 ? 4 : 6 + headerBlockLength;
            ChannelBuffer frame = ChannelBuffers.buffer(ByteOrder.BIG_ENDIAN, 8 + length);
            frame.writeShort(32770);
            frame.writeShort(8);
            frame.writeInt(length);
            frame.writeInt(spdyHeadersFrame.getStreamID());
            if (data.readableBytes() != 0) {
                frame.writeShort(0);
            }
            return ChannelBuffers.wrappedBuffer(frame, data);
        }
        return msg;
    }

    private ChannelBuffer encodeHeaderBlock(SpdyHeaderBlock headerFrame) throws Exception {
        Set<String> names = headerFrame.getHeaderNames();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ChannelBuffer headerBlock = ChannelBuffers.dynamicBuffer(ByteOrder.BIG_ENDIAN, 256);
        headerBlock.writeShort(numHeaders);
        for (String name : names) {
            byte[] nameBytes = name.getBytes("UTF-8");
            headerBlock.writeShort(nameBytes.length);
            headerBlock.writeBytes(nameBytes);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            headerBlock.writeShort(valueLength);
            for (String value : headerFrame.getHeaders(name)) {
                byte[] valueBytes = value.getBytes("UTF-8");
                headerBlock.writeBytes(valueBytes);
                headerBlock.writeByte(0);
                valueLength += valueBytes.length + 1;
            }
            if (--valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name);
            }
            headerBlock.setShort(savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ChannelBuffer compressHeaderBlock(ChannelBuffer uncompressed) throws Exception {
        if (uncompressed.readableBytes() == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer compressed = ChannelBuffers.dynamicBuffer();
        SpdyHeaderBlockCompressor spdyHeaderBlockCompressor = this.headerBlockCompressor;
        synchronized (spdyHeaderBlockCompressor) {
            if (!this.finished) {
                this.headerBlockCompressor.setInput(uncompressed);
                this.headerBlockCompressor.encode(compressed);
            }
        }
        return compressed;
    }
}

