/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import javax.annotation.security.RunAs;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.security.metadata.EJBBoundSecurityMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.RunAsPrincipal;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;

public class RunAsMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    private static final String DEFAULT_RUN_AS_PRINCIPAL = "anonymous";

    public RunAsMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation runAs = clazz.getAnnotationInformation(RunAs.class);
        if (runAs == null) {
            return;
        }
        if (!runAs.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setRunAs((String)runAs.getClassLevelAnnotations().get(0));
        }
        ClassAnnotationInformation runAsPrincipal = clazz.getAnnotationInformation(RunAsPrincipal.class);
        String principal = DEFAULT_RUN_AS_PRINCIPAL;
        if (runAsPrincipal != null && !runAsPrincipal.getClassLevelAnnotations().isEmpty()) {
            principal = (String)runAsPrincipal.getClassLevelAnnotations().get(0);
        }
        componentConfiguration.setRunAsPrincipal(principal);
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        String role;
        RunAsMetaData runAs;
        SecurityIdentityMetaData identity;
        if (componentConfiguration.getDescriptorData() != null && (identity = componentConfiguration.getDescriptorData().getSecurityIdentity()) != null && (runAs = identity.getRunAs()) != null && (role = runAs.getRoleName()) != null && !role.trim().isEmpty()) {
            componentConfiguration.setRunAs(role.trim());
        }
        if (componentConfiguration.getRunAs() != null) {
            String principal = null;
            String globalRunAsPrincipal = null;
            EjbJarMetaData jbossMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
            if (jbossMetaData != null && jbossMetaData.getAssemblyDescriptor() != null) {
                List securityMetaDatas = jbossMetaData.getAssemblyDescriptor().getAny(EJBBoundSecurityMetaData.class);
                if (securityMetaDatas != null) {
                    for (EJBBoundSecurityMetaData securityMetaData : securityMetaDatas) {
                        if (securityMetaData.getEjbName().equals(componentConfiguration.getComponentName())) {
                            principal = securityMetaData.getRunAsPrincipal();
                            break;
                        }
                        if (!securityMetaData.getEjbName().equals("*")) continue;
                        globalRunAsPrincipal = securityMetaData.getRunAsPrincipal();
                    }
                }
                if (principal != null) {
                    componentConfiguration.setRunAsPrincipal(principal);
                } else if (globalRunAsPrincipal != null) {
                    componentConfiguration.setRunAsPrincipal(globalRunAsPrincipal);
                } else {
                    componentConfiguration.setRunAsPrincipal(DEFAULT_RUN_AS_PRINCIPAL);
                }
            }
        }
    }
}

