/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.remote.SecurityActions;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class RemoteViewManagedReferenceFactory
implements ContextListAndJndiViewManagedReferenceFactory {
    private final String appName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;
    private final String viewClass;
    private final boolean stateful;
    private final Value<ClassLoader> viewClassLoader;

    public RemoteViewManagedReferenceFactory(String appName, String moduleName, String distinctName, String beanName, String viewClass, boolean stateful) {
        this(appName, moduleName, distinctName, beanName, viewClass, stateful, null);
    }

    public RemoteViewManagedReferenceFactory(String appName, String moduleName, String distinctName, String beanName, String viewClass, boolean stateful, Value<ClassLoader> viewClassLoader) {
        this.appName = appName == null ? "" : appName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
        this.viewClass = viewClass;
        this.stateful = stateful;
        this.viewClassLoader = viewClassLoader;
    }

    public String getInstanceClassName() {
        return this.viewClass;
    }

    public String getJndiViewInstanceValue() {
        return this.stateful ? "?" : String.valueOf(this.getReference().getInstance());
    }

    public ManagedReference getReference() {
        Class<?> viewClass;
        try {
            viewClass = Class.forName(this.viewClass, false, SecurityActions.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (this.viewClassLoader == null) {
                throw EjbMessages.MESSAGES.failToLoadViewClassEjb(this.beanName, e);
            }
            try {
                viewClass = Class.forName(this.viewClass, false, (ClassLoader)this.viewClassLoader.getValue());
            }
            catch (ClassNotFoundException ce) {
                throw EjbMessages.MESSAGES.failToLoadViewClassEjb(this.beanName, ce);
            }
        }
        EJBHomeLocator ejbLocator = null;
        if (EJBHome.class.isAssignableFrom(viewClass) || EJBLocalHome.class.isAssignableFrom(viewClass)) {
            ejbLocator = new EJBHomeLocator(viewClass, this.appName, this.moduleName, this.beanName, this.distinctName);
        } else if (this.stateful) {
            try {
                ejbLocator = EJBClient.createSession(viewClass, (String)this.appName, (String)this.moduleName, (String)this.beanName, (String)this.distinctName);
            }
            catch (Exception e) {
                throw EjbMessages.MESSAGES.failedToCreateSessionForStatefulBean(e, this.beanName);
            }
        } else {
            ejbLocator = new StatelessEJBLocator(viewClass, this.appName, this.moduleName, this.beanName, this.distinctName);
        }
        Object proxy = EJBClient.createProxy((EJBLocator)ejbLocator);
        return new ValueManagedReference((Value)new ImmediateValue(proxy));
    }
}

