/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.AbstractOperationTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderLoader;
import org.jboss.as.jpa.processor.PersistenceProviderAdaptorLoader;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.as.jpa.subsystem.Attribute;
import org.jboss.as.jpa.subsystem.Element;
import org.jboss.as.jpa.subsystem.JPADefinition;
import org.jboss.as.jpa.subsystem.JPASubsystemTransformer_1_1;
import org.jboss.as.jpa.subsystem.Namespace;
import org.jboss.as.jpa.subsystem.PersistenceUnitRegistryImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoadException;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JPAExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jpa";
    private static final JPASubsystemElementParser1_1 parser1_1 = new JPASubsystemElementParser1_1();
    private static final JPASubsystemElementParser1_0 parser1_0 = new JPASubsystemElementParser1_0();
    private static final String RESOURCE_NAME = JPAExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JPAExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration nodeRegistration = registration.registerSubsystemModel((ResourceDefinition)JPADefinition.INSTANCE);
        nodeRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        registration.registerXMLElementWriter((XMLElementWriter)parser1_1);
        this.initializeTransformers_1_1_0(registration);
        try {
            PersistenceProviderLoader.loadDefaultProvider();
        }
        catch (ModuleLoadException e) {
            JpaLogger.JPA_LOGGER.errorPreloadingDefaultProvider((Throwable)e);
        }
        try {
            PersistenceProviderAdaptor provider = PersistenceProviderAdaptorLoader.loadPersistenceAdapterModule("org.jboss.as.jpa.hibernate:4");
            ManagementAdaptor managementAdaptor = provider.getManagementAdaptor();
            if (managementAdaptor != null && context.isRuntimeOnlyRegistrationValid()) {
                ManagementResourceRegistration jpaSubsystemDeployments = registration.registerDeploymentModel((ResourceDefinition)JPADefinition.INSTANCE);
                managementAdaptor.register(jpaSubsystemDeployments, (PersistenceUnitServiceRegistry)PersistenceUnitRegistryImpl.INSTANCE);
            }
        }
        catch (ModuleLoadException e) {
            JpaLogger.JPA_LOGGER.errorPreloadingDefaultProviderAdaptor((Throwable)e);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JPA_1_1.getUriString(), (XMLElementReader)parser1_1);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JPA_1_0.getUriString(), (XMLElementReader)parser1_0);
    }

    private void initializeTransformers_1_1_0(SubsystemRegistration subsystemRegistration) {
        RejectExpressionValuesTransformer rejectNewerExpressions = new RejectExpressionValuesTransformer(new AttributeDefinition[]{JPADefinition.DEFAULT_DATASOURCE, JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE, JPADefinition.DEFAULT_VFS});
        TransformersSubRegistration reg = subsystemRegistration.registerModelTransformers((ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0), (ResourceTransformer)new JPASubsystemTransformer_1_1());
        reg.registerOperationTransformer("add", (OperationTransformer)new AbstractOperationTransformer(){

            protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
                if (operation.has(JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE.getName())) {
                    operation.remove(JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE.getName());
                }
                if (operation.has(JPADefinition.DEFAULT_VFS.getName())) {
                    operation.remove(JPADefinition.DEFAULT_VFS.getName());
                }
                return operation;
            }
        });
        reg.registerOperationTransformer("write-attribute", rejectNewerExpressions.getWriteAttributeTransformer());
    }

    static class JPASubsystemElementParser1_0
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        JPASubsystemElementParser1_0() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode subsystemAdd = null;
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case JPA: {
                        subsystemAdd = this.parseJPA(reader, readerNS);
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (subsystemAdd == null) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.JPA.getLocalName()));
            }
            list.add(subsystemAdd);
        }

        private ModelNode parseJPA(XMLExtendedStreamReader reader, Namespace readerNS) throws XMLStreamException {
            ModelNode operation = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)JPAExtension.SUBSYSTEM_NAME)}));
            String dataSourceName = null;
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DEFAULT_DATASOURCE_NAME: {
                        dataSourceName = value;
                        JPADefinition.DEFAULT_DATASOURCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (dataSourceName == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.DEFAULT_DATASOURCE_NAME));
            }
            return operation;
        }
    }

    static class JPASubsystemElementParser1_1
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        JPASubsystemElementParser1_1() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode subsystemAdd = null;
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case JPA: {
                        subsystemAdd = this.parseJPA(reader, readerNS);
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (subsystemAdd == null) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.JPA.getLocalName()));
            }
            list.add(subsystemAdd);
        }

        private ModelNode parseJPA(XMLExtendedStreamReader reader, Namespace readerNS) throws XMLStreamException {
            String dataSourceName = null;
            ModelNode operation = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)JPAExtension.SUBSYSTEM_NAME)}));
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DEFAULT_DATASOURCE_NAME: {
                        dataSourceName = value;
                        JPADefinition.DEFAULT_DATASOURCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case DEFAULT_EXTENDEDPERSISTENCEINHERITANCE_NAME: {
                        JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case DEFAULT_VFS_NAME: {
                        JPADefinition.DEFAULT_VFS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (dataSourceName == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.DEFAULT_DATASOURCE_NAME));
            }
            return operation;
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            if (node.hasDefined("default-datasource") || node.hasDefined("default-extended-persistence-inheritance") || node.hasDefined("default-vfs")) {
                context.startSubsystemElement(Namespace.JPA_1_1.getUriString(), false);
                writer.writeStartElement(Element.JPA.getLocalName());
                JPADefinition.DEFAULT_DATASOURCE.marshallAsAttribute(node, (XMLStreamWriter)writer);
                JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE.marshallAsAttribute(node, (XMLStreamWriter)writer);
                JPADefinition.DEFAULT_VFS.marshallAsAttribute(node, (XMLStreamWriter)writer);
                writer.writeEndElement();
                writer.writeEndElement();
            } else {
                context.startSubsystemElement(Namespace.JPA_1_1.getUriString(), false);
                writer.writeEndElement();
            }
        }
    }
}

