/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.AbstractOperationTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.mail.extension.MailSubsystemModel;
import org.jboss.as.mail.extension.MailSubsystemParser;
import org.jboss.as.mail.extension.MailSubsystemResource;
import org.jboss.as.mail.extension.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MailExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "mail";
    private final MailSubsystemParser parser = new MailSubsystemParser();
    private static final String RESOURCE_NAME = MailExtension.class.getPackage().getName() + ".LocalDescriptions";
    static PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"mail");
    static PathElement MAIL_SESSION_PATH = PathElement.pathElement((String)"mail-session");
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, MailExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MAIL_1_0.getUriString(), (XMLElementReader)this.parser);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.MAIL_1_1.getUriString(), (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration subsystemRegistration = subsystem.registerSubsystemModel((ResourceDefinition)MailSubsystemResource.INSTANCE);
        subsystemRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration session = subsystemRegistration.registerSubModel((ResourceDefinition)MailSessionDefinition.INSTANCE);
        session.registerSubModel((ResourceDefinition)MailServerDefinition.INSTANCE_IMAP);
        session.registerSubModel((ResourceDefinition)MailServerDefinition.INSTANCE_POP3);
        session.registerSubModel((ResourceDefinition)MailServerDefinition.INSTANCE_SMTP);
        session.registerSubModel((ResourceDefinition)MailServerDefinition.INSTANCE_CUSTOM);
        subsystem.registerXMLElementWriter((XMLElementWriter)this.parser);
        TransformersSubRegistration sessionTransformers = subsystem.registerModelTransformers((ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0), null).registerSubResource(MAIL_SESSION_PATH);
        TransformersSubRegistration serverTransformers = sessionTransformers.registerSubResource(MailSubsystemModel.SMTP_SERVER_PATH, new ResourceTransformer(){

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode serverModel = resource.getModel();
                if (serverModel.has("tls")) {
                    serverModel.remove("tls");
                }
            }
        });
        serverTransformers.registerOperationTransformer("add", (OperationTransformer)new AbstractOperationTransformer(){

            protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
                if (operation.has("tls")) {
                    operation.remove("tls");
                }
                return operation;
            }
        });
        sessionTransformers.registerSubResource(MailSubsystemModel.CUSTOM_SERVER_PATH, true);
    }
}

