/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.impl.AbstractAuditQuery;
import org.hibernate.envers.reader.AuditReaderImplementor;

public class EntitiesModifiedAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;

    public EntitiesModifiedAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, Number revision) {
        super(verCfg, versionsReader, cls);
        this.revision = revision;
    }

    public EntitiesModifiedAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision) {
        super(verCfg, versionsReader, cls, entityName);
        this.revision = revision;
    }

    @Override
    public List list() {
        AuditEntitiesConfiguration verEntCfg = this.verCfg.getAuditEntCfg();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        this.qb.getRootParameters().addWhereWithParam(revisionPropertyPath, "=", this.revision);
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.verCfg, this.entityName, this.qb, this.qb.getRootParameters());
        }
        Query query = this.buildQuery();
        List queryResult = query.list();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList result = new ArrayList();
        this.entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, this.revision);
        return result;
    }
}

