/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;

public class JMSConnectionFactoryControlImpl
extends StandardMBean
implements ConnectionFactoryControl {
    private final ConnectionFactoryConfiguration cfConfig;
    private HornetQConnectionFactory cf;
    private final String name;
    private final JMSServerManager jmsManager;

    public JMSConnectionFactoryControlImpl(ConnectionFactoryConfiguration cfConfig, HornetQConnectionFactory cf, JMSServerManager jmsManager, String name) throws NotCompliantMBeanException {
        super(ConnectionFactoryControl.class);
        this.cfConfig = cfConfig;
        this.cf = cf;
        this.name = name;
        this.jmsManager = jmsManager;
    }

    @Override
    public String[] getJNDIBindings() {
        return this.jmsManager.getJNDIOnConnectionFactory(this.name);
    }

    @Override
    public boolean isCompressLargeMessages() {
        return this.cf.isCompressLargeMessage();
    }

    @Override
    public void setCompressLargeMessages(boolean compress) {
        this.cfConfig.setCompressLargeMessages(compress);
        this.recreateCF();
    }

    @Override
    public boolean isHA() {
        return this.cfConfig.isHA();
    }

    @Override
    public int getFactoryType() {
        return this.cfConfig.getFactoryType().intValue();
    }

    @Override
    public String getClientID() {
        return this.cfConfig.getClientID();
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.cfConfig.getClientFailureCheckPeriod();
    }

    @Override
    public void setClientID(String clientID) {
        this.cfConfig.setClientID(clientID);
        this.recreateCF();
    }

    @Override
    public void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.cfConfig.setDupsOKBatchSize(dupsOKBatchSize);
        this.recreateCF();
    }

    @Override
    public void setTransactionBatchSize(int transactionBatchSize) {
        this.cfConfig.setTransactionBatchSize(transactionBatchSize);
        this.recreateCF();
    }

    @Override
    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.cfConfig.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        this.recreateCF();
    }

    @Override
    public void setConnectionTTL(long connectionTTL) {
        this.cfConfig.setConnectionTTL(connectionTTL);
        this.recreateCF();
    }

    @Override
    public void setCallTimeout(long callTimeout) {
        this.cfConfig.setCallTimeout(callTimeout);
        this.recreateCF();
    }

    @Override
    public void setCallFailoverTimeout(long callTimeout) {
        this.cfConfig.setCallFailoverTimeout(callTimeout);
        this.recreateCF();
    }

    @Override
    public void setConsumerWindowSize(int consumerWindowSize) {
        this.cfConfig.setConsumerWindowSize(consumerWindowSize);
        this.recreateCF();
    }

    @Override
    public void setConsumerMaxRate(int consumerMaxRate) {
        this.cfConfig.setConsumerMaxRate(consumerMaxRate);
        this.recreateCF();
    }

    @Override
    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.cfConfig.setConfirmationWindowSize(confirmationWindowSize);
        this.recreateCF();
    }

    @Override
    public void setProducerMaxRate(int producerMaxRate) {
        this.cfConfig.setProducerMaxRate(producerMaxRate);
        this.recreateCF();
    }

    @Override
    public int getProducerWindowSize() {
        return this.cfConfig.getProducerWindowSize();
    }

    @Override
    public void setProducerWindowSize(int producerWindowSize) {
        this.cfConfig.setProducerWindowSize(producerWindowSize);
        this.recreateCF();
    }

    @Override
    public void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cfConfig.setCacheLargeMessagesClient(cacheLargeMessagesClient);
        this.recreateCF();
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cfConfig.isCacheLargeMessagesClient();
    }

    @Override
    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.cfConfig.setMinLargeMessageSize(minLargeMessageSize);
        this.recreateCF();
    }

    @Override
    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.cfConfig.setBlockOnNonDurableSend(blockOnNonDurableSend);
        this.recreateCF();
    }

    @Override
    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.cfConfig.setBlockOnAcknowledge(blockOnAcknowledge);
        this.recreateCF();
    }

    @Override
    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.cfConfig.setBlockOnDurableSend(blockOnDurableSend);
        this.recreateCF();
    }

    @Override
    public void setAutoGroup(boolean autoGroup) {
        this.cfConfig.setAutoGroup(autoGroup);
        this.recreateCF();
    }

    @Override
    public void setPreAcknowledge(boolean preAcknowledge) {
        this.cfConfig.setPreAcknowledge(preAcknowledge);
        this.recreateCF();
    }

    @Override
    public void setMaxRetryInterval(long retryInterval) {
        this.cfConfig.setMaxRetryInterval(retryInterval);
        this.recreateCF();
    }

    @Override
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.cfConfig.setRetryIntervalMultiplier(retryIntervalMultiplier);
        this.recreateCF();
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.cfConfig.setReconnectAttempts(reconnectAttempts);
        this.recreateCF();
    }

    @Override
    public void setFailoverOnInitialConnection(boolean failover) {
        this.cfConfig.setFailoverOnInitialConnection(failover);
        this.recreateCF();
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.cfConfig.isUseGlobalPools();
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.cfConfig.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        this.recreateCF();
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.cfConfig.getThreadPoolMaxSize();
    }

    @Override
    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.cfConfig.setThreadPoolMaxSize(threadPoolMaxSize);
        this.recreateCF();
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.cf.getInitialMessagePacketSize();
    }

    @Override
    public void setGroupID(String groupID) {
        this.cfConfig.setGroupID(groupID);
        this.recreateCF();
    }

    @Override
    public String getGroupID() {
        return this.cfConfig.getGroupID();
    }

    @Override
    public void setUseGlobalPools(boolean useGlobalPools) {
        this.cfConfig.setUseGlobalPools(useGlobalPools);
        this.recreateCF();
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.cfConfig.getScheduledThreadPoolMaxSize();
    }

    @Override
    public void setRetryInterval(long retryInterval) {
        this.cfConfig.setRetryInterval(retryInterval);
        this.recreateCF();
    }

    @Override
    public long getMaxRetryInterval() {
        return this.cfConfig.getMaxRetryInterval();
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.cfConfig.getLoadBalancingPolicyClassName();
    }

    @Override
    public void setConnectionLoadBalancingPolicyClassName(String name) {
        this.cfConfig.setLoadBalancingPolicyClassName(name);
        this.recreateCF();
    }

    @Override
    public TransportConfiguration[] getStaticConnectors() {
        return this.cf.getStaticConnectors();
    }

    @Override
    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.cf.getDiscoveryGroupConfiguration();
    }

    @Override
    public void addJNDI(@Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String jndi) throws Exception {
        this.jmsManager.addConnectionFactoryToJNDI(this.name, jndi);
    }

    @Override
    public void removeJNDI(@Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String jndi) throws Exception {
        this.jmsManager.removeConnectionFactoryFromJNDI(this.name, jndi);
    }

    @Override
    public long getCallTimeout() {
        return this.cfConfig.getCallTimeout();
    }

    @Override
    public long getCallFailoverTimeout() {
        return this.cfConfig.getCallFailoverTimeout();
    }

    @Override
    public int getConsumerMaxRate() {
        return this.cfConfig.getConsumerMaxRate();
    }

    @Override
    public int getConsumerWindowSize() {
        return this.cfConfig.getConsumerWindowSize();
    }

    @Override
    public int getProducerMaxRate() {
        return this.cfConfig.getProducerMaxRate();
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.cfConfig.getConfirmationWindowSize();
    }

    @Override
    public int getDupsOKBatchSize() {
        return this.cfConfig.getDupsOKBatchSize();
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.cfConfig.isBlockOnAcknowledge();
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.cfConfig.isBlockOnNonDurableSend();
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.cfConfig.isBlockOnDurableSend();
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.cfConfig.isPreAcknowledge();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getConnectionTTL() {
        return this.cfConfig.getConnectionTTL();
    }

    @Override
    public int getReconnectAttempts() {
        return this.cfConfig.getReconnectAttempts();
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.cfConfig.isFailoverOnInitialConnection();
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.cfConfig.getMinLargeMessageSize();
    }

    @Override
    public long getRetryInterval() {
        return this.cfConfig.getRetryInterval();
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.cfConfig.getRetryIntervalMultiplier();
    }

    @Override
    public int getTransactionBatchSize() {
        return this.cfConfig.getTransactionBatchSize();
    }

    @Override
    public boolean isAutoGroup() {
        return this.cfConfig.isAutoGroup();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(ConnectionFactoryControl.class), info.getNotifications());
    }

    private void recreateCF() {
        try {
            this.cf = this.jmsManager.recreateCF(this.name, this.cfConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

