/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.persistence.impl.journal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.replication.ReplicatedJournal;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.JournalType;
import org.hornetq.jms.persistence.JMSStorageManager;
import org.hornetq.jms.persistence.config.PersistedConnectionFactory;
import org.hornetq.jms.persistence.config.PersistedDestination;
import org.hornetq.jms.persistence.config.PersistedJNDI;
import org.hornetq.jms.persistence.config.PersistedType;
import org.hornetq.utils.IDGenerator;
import org.hornetq.utils.Pair;

public class JMSJournalStorageManagerImpl
implements JMSStorageManager {
    private static final byte CF_RECORD = 1;
    private static final byte DESTINATION_RECORD = 2;
    private static final byte JNDI_RECORD = 3;
    private final IDGenerator idGenerator;
    private final String journalDir;
    private final boolean createDir;
    private final Journal jmsJournal;
    private volatile boolean started;
    private final Map<String, PersistedConnectionFactory> mapFactories = new ConcurrentHashMap<String, PersistedConnectionFactory>();
    private final Map<Pair<PersistedType, String>, PersistedDestination> destinations = new ConcurrentHashMap<Pair<PersistedType, String>, PersistedDestination>();
    private final Map<Pair<PersistedType, String>, PersistedJNDI> mapJNDI = new ConcurrentHashMap<Pair<PersistedType, String>, PersistedJNDI>();

    public JMSJournalStorageManagerImpl(IDGenerator idGenerator, Configuration config, ReplicationManager replicator) {
        if (config.getJournalType() != JournalType.NIO && config.getJournalType() != JournalType.ASYNCIO) {
            throw new IllegalArgumentException("Only NIO and AsyncIO are supported journals");
        }
        this.journalDir = config.getBindingsDirectory();
        if (this.journalDir == null) {
            throw new NullPointerException("bindings-dir is null");
        }
        this.createDir = config.isCreateBindingsDir();
        NIOSequentialFileFactory bindingsJMS = new NIOSequentialFileFactory(this.journalDir);
        JournalImpl localJMS = new JournalImpl(0x100000, 2, config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), (SequentialFileFactory)bindingsJMS, "hornetq-jms", "jms", 1);
        this.jmsJournal = replicator != null ? new ReplicatedJournal(2, (Journal)localJMS, replicator) : localJMS;
        this.idGenerator = idGenerator;
    }

    @Override
    public List<PersistedConnectionFactory> recoverConnectionFactories() {
        ArrayList<PersistedConnectionFactory> cfs = new ArrayList<PersistedConnectionFactory>(this.mapFactories.size());
        cfs.addAll(this.mapFactories.values());
        return cfs;
    }

    @Override
    public void storeConnectionFactory(PersistedConnectionFactory connectionFactory) throws Exception {
        this.deleteConnectionFactory(connectionFactory.getName());
        long id = this.idGenerator.generateID();
        connectionFactory.setId(id);
        this.jmsJournal.appendAddRecord(id, (byte)1, (EncodingSupport)connectionFactory, true);
        this.mapFactories.put(connectionFactory.getName(), connectionFactory);
    }

    @Override
    public void deleteConnectionFactory(String cfName) throws Exception {
        PersistedConnectionFactory oldCF = this.mapFactories.remove(cfName);
        if (oldCF != null) {
            this.jmsJournal.appendDeleteRecord(oldCF.getId(), false);
        }
    }

    @Override
    public List<PersistedDestination> recoverDestinations() {
        ArrayList<PersistedDestination> destinations = new ArrayList<PersistedDestination>(this.destinations.size());
        destinations.addAll(this.destinations.values());
        return destinations;
    }

    @Override
    public void storeDestination(PersistedDestination destination) throws Exception {
        this.deleteDestination(destination.getType(), destination.getName());
        long id = this.idGenerator.generateID();
        destination.setId(id);
        this.jmsJournal.appendAddRecord(id, (byte)2, (EncodingSupport)destination, true);
        this.destinations.put((Pair<PersistedType, String>)new Pair((Object)destination.getType(), (Object)destination.getName()), destination);
    }

    @Override
    public List<PersistedJNDI> recoverPersistedJNDI() throws Exception {
        ArrayList<PersistedJNDI> list = new ArrayList<PersistedJNDI>();
        list.addAll(this.mapJNDI.values());
        return list;
    }

    @Override
    public void addJNDI(PersistedType type, String name, String ... address) throws Exception {
        Pair key = new Pair((Object)type, (Object)name);
        long tx = this.idGenerator.generateID();
        PersistedJNDI currentJNDI = this.mapJNDI.get(key);
        if (currentJNDI != null) {
            this.jmsJournal.appendDeleteRecordTransactional(tx, currentJNDI.getId());
        } else {
            currentJNDI = new PersistedJNDI(type, name);
        }
        this.mapJNDI.put((Pair<PersistedType, String>)key, currentJNDI);
        for (String adItem : address) {
            currentJNDI.addJNDI(adItem);
        }
        long newId = this.idGenerator.generateID();
        currentJNDI.setId(newId);
        this.jmsJournal.appendAddRecordTransactional(tx, newId, (byte)3, (EncodingSupport)currentJNDI);
        this.jmsJournal.appendCommitRecord(tx, true);
    }

    @Override
    public void deleteJNDI(PersistedType type, String name, String address) throws Exception {
        Pair key = new Pair((Object)type, (Object)name);
        long tx = this.idGenerator.generateID();
        PersistedJNDI currentJNDI = this.mapJNDI.get(key);
        if (currentJNDI == null) {
            return;
        }
        this.jmsJournal.appendDeleteRecordTransactional(tx, currentJNDI.getId());
        currentJNDI.deleteJNDI(address);
        if (currentJNDI.getJndi().size() == 0) {
            this.mapJNDI.remove(key);
        } else {
            long newId = this.idGenerator.generateID();
            currentJNDI.setId(newId);
            this.jmsJournal.appendAddRecordTransactional(tx, newId, (byte)3, (EncodingSupport)currentJNDI);
        }
        this.jmsJournal.appendCommitRecord(tx, true);
    }

    @Override
    public void deleteJNDI(PersistedType type, String name) throws Exception {
        Pair key = new Pair((Object)type, (Object)name);
        PersistedJNDI currentJNDI = this.mapJNDI.remove(key);
        if (currentJNDI != null) {
            this.jmsJournal.appendDeleteRecord(currentJNDI.getId(), true);
        }
    }

    @Override
    public void deleteDestination(PersistedType type, String name) throws Exception {
        PersistedDestination destination = this.destinations.remove(new Pair((Object)type, (Object)name));
        if (destination != null) {
            this.jmsJournal.appendDeleteRecord(destination.getId(), false);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        this.checkAndCreateDir(this.journalDir, this.createDir);
        this.jmsJournal.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        this.jmsJournal.stop();
    }

    @Override
    public void load() throws Exception {
        this.mapFactories.clear();
        ArrayList data = new ArrayList();
        ArrayList list = new ArrayList();
        this.jmsJournal.load(data, list, null);
        for (RecordInfo record : data) {
            long id = record.id;
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((byte[])record.data);
            byte rec = record.getUserRecordType();
            if (rec == 1) {
                PersistedConnectionFactory cf = new PersistedConnectionFactory();
                cf.decode(buffer);
                cf.setId(id);
                this.mapFactories.put(cf.getName(), cf);
                continue;
            }
            if (rec == 2) {
                PersistedDestination destination = new PersistedDestination();
                destination.decode(buffer);
                destination.setId(id);
                this.destinations.put((Pair<PersistedType, String>)new Pair((Object)destination.getType(), (Object)destination.getName()), destination);
                continue;
            }
            if (rec == 3) {
                PersistedJNDI jndi = new PersistedJNDI();
                jndi.decode(buffer);
                jndi.setId(id);
                Pair key = new Pair((Object)jndi.getType(), (Object)jndi.getName());
                this.mapJNDI.put((Pair<PersistedType, String>)key, jndi);
                continue;
            }
            throw new IllegalStateException("Invalid record type " + rec);
        }
    }

    private void checkAndCreateDir(String dir, boolean create) {
        File f = new File(dir);
        if (!f.exists()) {
            if (create) {
                if (!f.mkdirs()) {
                    throw new IllegalStateException("Failed to create directory " + dir);
                }
            } else {
                throw new IllegalArgumentException("Directory " + dir + " does not exist and will not create it");
            }
        }
    }
}

