/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxrpc.client.CallImpl;
import org.jboss.ws.core.jaxrpc.client.HandlerRegistryImpl;
import org.jboss.ws.core.jaxrpc.client.PortProxy;
import org.jboss.ws.core.jaxrpc.client.SecurityActions;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCClientMetaDataBuilder;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class ServiceImpl
implements ServiceExt,
Serializable,
Externalizable {
    private transient ServiceMetaData serviceMetaData;
    private QName serviceName;
    private URL wsdlLocation;
    private URL mappingURL;
    private JavaWsdlMapping mappingConfig;
    private UnifiedServiceRefMetaData usrMetaData;
    private transient HandlerRegistryImpl handlerRegistry;

    public ServiceImpl() {
    }

    public ServiceImpl(QName serviceName) {
        this.serviceName = serviceName;
        this.init();
    }

    public ServiceImpl(QName serviceName, URL wsdlURL, URL mappingURL, URL securityURL) {
        this.serviceName = serviceName;
        this.wsdlLocation = wsdlURL;
        this.mappingURL = mappingURL;
        this.init();
    }

    public ServiceImpl(QName serviceName, URL wsdlURL, JavaWsdlMapping mappingURL, UnifiedServiceRefMetaData usrMetaData) {
        this.serviceName = serviceName;
        this.wsdlLocation = wsdlURL;
        this.mappingConfig = mappingURL;
        this.usrMetaData = usrMetaData;
        this.init();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.serviceName);
        out.writeObject(this.wsdlLocation);
        out.writeObject(this.mappingURL);
        out.writeObject(this.mappingConfig);
        out.writeObject(this.usrMetaData);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serviceName = (QName)in.readObject();
        this.wsdlLocation = (URL)in.readObject();
        this.mappingURL = (URL)in.readObject();
        this.mappingConfig = (JavaWsdlMapping)in.readObject();
        this.usrMetaData = (UnifiedServiceRefMetaData)in.readObject();
        this.init();
    }

    private void init() {
        if (this.wsdlLocation == null && this.mappingURL == null && this.mappingConfig == null && this.usrMetaData == null) {
            UnifiedMetaData wsMetaData = new UnifiedMetaData((UnifiedVirtualFile)new ResourceLoaderAdapter());
            this.serviceMetaData = new ServiceMetaData(wsMetaData, this.serviceName);
            this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
            return;
        }
        if (this.mappingURL != null) {
            JAXRPCClientMetaDataBuilder builder = new JAXRPCClientMetaDataBuilder();
            ClassLoader ctxClassLoader = SecurityActions.getContextClassLoader();
            this.serviceMetaData = builder.buildMetaData(this.serviceName, this.wsdlLocation, this.mappingURL, null, ctxClassLoader);
            this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
            return;
        }
        JAXRPCClientMetaDataBuilder builder = new JAXRPCClientMetaDataBuilder();
        ClassLoader ctxClassLoader = SecurityActions.getContextClassLoader();
        this.serviceMetaData = builder.buildMetaData(this.serviceName, this.wsdlLocation, this.mappingConfig, this.usrMetaData, ctxClassLoader);
        this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public QName getServiceName() {
        return this.serviceMetaData.getServiceName();
    }

    public Call createCall(QName portName) throws ServiceException {
        String nsURI = portName.getNamespaceURI();
        this.serviceMetaData.assertTargetNamespace(nsURI);
        CallImpl call = new CallImpl(this, portName, null);
        this.initCallProperties(call, null);
        return call;
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        String nsURI = portName.getNamespaceURI();
        this.serviceMetaData.assertTargetNamespace(nsURI);
        QName opName = new QName(nsURI, operationName);
        CallImpl call = new CallImpl(this, portName, opName);
        this.initCallProperties(call, null);
        return call;
    }

    public Call createCall(QName portName, QName opName) throws ServiceException {
        this.serviceMetaData.assertTargetNamespace(portName.getNamespaceURI());
        this.serviceMetaData.assertTargetNamespace(opName.getNamespaceURI());
        CallImpl call = new CallImpl(this, portName, opName);
        this.initCallProperties(call, null);
        return call;
    }

    public Call createCall() throws ServiceException {
        CallImpl call = new CallImpl(this);
        this.initCallProperties(call, null);
        return call;
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw NativeMessages.MESSAGES.cannotFindEndpointForName(portName);
        }
        ArrayList<Call> calls = new ArrayList<Call>();
        for (OperationMetaData opMetaData : epMetaData.getOperations()) {
            Call call = this.createCall(portName, opMetaData.getQName());
            calls.add(call);
        }
        Call[] callArr = new Call[calls.size()];
        calls.toArray(callArr);
        return callArr;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw NativeMessages.MESSAGES.shouldNotUseMethod("getHandlerRegistry()");
    }

    @Override
    public HandlerRegistry getDynamicHandlerRegistry() {
        return this.handlerRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw NativeMessages.MESSAGES.shouldNotUseMethod("getTypeMappingRegistry()");
    }

    public Iterator getPorts() throws ServiceException {
        ArrayList<QName> list = new ArrayList<QName>();
        if (this.serviceMetaData != null) {
            for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints()) {
                list.add(epMetaData.getPortName());
            }
        }
        return list.iterator();
    }

    public Remote getPort(Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("seiClass");
        }
        String seiName = seiClass.getName();
        if (!Remote.class.isAssignableFrom(seiClass)) {
            throw new ServiceException(NativeMessages.MESSAGES.notImplementRemote(seiName));
        }
        if (this.serviceMetaData == null) {
            throw NativeMessages.MESSAGES.serviceMetaDataNotAvailable();
        }
        try {
            EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiName);
            if (epMetaData == null && this.serviceMetaData.getEndpoints().size() == 1) {
                epMetaData = this.serviceMetaData.getEndpoints().get(0);
                epMetaData.setServiceEndpointInterfaceName(seiName);
            }
            if (epMetaData == null) {
                throw NativeMessages.MESSAGES.cannotFindEndpointMetaData(seiName);
            }
            return this.createProxy(seiClass, epMetaData);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public Remote getPort(QName portName, Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("seiClass");
        }
        if (this.serviceMetaData == null) {
            throw NativeMessages.MESSAGES.serviceMetaDataNotAvailable();
        }
        String seiName = seiClass.getName();
        if (!Remote.class.isAssignableFrom(seiClass)) {
            throw new ServiceException(NativeMessages.MESSAGES.notImplementRemote(seiName));
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw NativeMessages.MESSAGES.cannotFindEndpointMetaData(portName);
        }
        try {
            if (epMetaData.getServiceEndpointInterfaceName() == null) {
                epMetaData.setServiceEndpointInterfaceName(seiName);
            }
            return this.createProxy(seiClass, epMetaData);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    private Remote createProxy(Class seiClass, EndpointMetaData epMetaData) throws Exception {
        CallImpl call = new CallImpl(this, epMetaData);
        this.initStubProperties(call, seiClass.getName());
        if (this.initCallProperties(call, seiClass.getName()) > 0) {
            NativeLoggers.JAXRPC_LOGGER.deprecatedUseOfCallPropsOnJAXRPCStub();
        }
        PortProxy handler = new PortProxy(call);
        ClassLoader cl = epMetaData.getClassLoader();
        Remote proxy = (Remote)Proxy.newProxyInstance(cl, new Class[]{seiClass, Stub.class, StubExt.class}, (InvocationHandler)handler);
        this.setupHandlerChain(epMetaData);
        return proxy;
    }

    private int initStubProperties(CallImpl call, String seiName) {
        if (this.usrMetaData == null) {
            return 0;
        }
        int propCount = 0;
        for (UnifiedPortComponentRefMetaData upcRef : this.usrMetaData.getPortComponentRefs()) {
            if (!seiName.equals(upcRef.getServiceEndpointInterface())) continue;
            for (UnifiedStubPropertyMetaData prop : upcRef.getStubProperties()) {
                call.setProperty(prop.getPropName(), prop.getPropValue());
                ++propCount;
            }
        }
        return propCount;
    }

    private int initCallProperties(CallImpl call, String seiName) {
        this.setupHandlerChain(call.getEndpointMetaData());
        if (this.usrMetaData == null) {
            return 0;
        }
        int propCount = 0;
        for (UnifiedCallPropertyMetaData prop : this.usrMetaData.getCallProperties()) {
            call.setProperty(prop.getPropName(), prop.getPropValue());
            ++propCount;
        }
        if (seiName != null) {
            for (UnifiedPortComponentRefMetaData upcRef : this.usrMetaData.getPortComponentRefs()) {
                if (!seiName.equals(upcRef.getServiceEndpointInterface())) continue;
                for (UnifiedCallPropertyMetaData prop : upcRef.getCallProperties()) {
                    call.setProperty(prop.getPropName(), prop.getPropValue());
                    ++propCount;
                }
            }
        }
        return propCount;
    }

    public HandlerChain getHandlerChain(QName portName) {
        return this.handlerRegistry.getHandlerChainInstance(portName);
    }

    public void registerHandlerChain(QName portName, List infos, Set roles) {
        this.handlerRegistry.registerClientHandlerChain(portName, infos, roles);
    }

    public void setupHandlerChain(EndpointMetaData epMetaData) {
        if (!epMetaData.isHandlersInitialized()) {
            QName portName = epMetaData.getPortName();
            HashSet<String> handlerRoles = new HashSet<String>();
            ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
            for (HandlerMetaData handlerMetaData : epMetaData.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL)) {
                HandlerMetaDataJAXRPC jaxrpcMetaData = (HandlerMetaDataJAXRPC)handlerMetaData;
                handlerRoles.addAll(jaxrpcMetaData.getSoapRoles());
                HashMap<String, String> hConfig = new HashMap<String, String>();
                for (UnifiedInitParamMetaData param : jaxrpcMetaData.getInitParams()) {
                    hConfig.put(param.getParamName(), param.getParamValue());
                }
                Set<QName> headers = jaxrpcMetaData.getSoapHeaders();
                QName[] headerArr = new QName[headers.size()];
                headers.toArray(headerArr);
                Class<?> hClass = jaxrpcMetaData.getHandlerClass();
                hConfig.put(UnifiedHandlerMetaData.HandlerType.class.getName(), (String)jaxrpcMetaData.getHandlerType());
                HandlerInfo info = new HandlerInfo(hClass, hConfig, headerArr);
                NativeLoggers.JAXRPC_LOGGER.addingClientSideHandlerToEndpoint(portName, info);
                handlerInfos.add(info);
            }
            if (handlerInfos.size() > 0) {
                this.registerHandlerChain(portName, handlerInfos, handlerRoles);
            }
            epMetaData.setHandlersInitialized(true);
        }
    }
}

