/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.jboss.logging.Logger;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.core.soap.BundleUtils;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HRefInlineHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(HRefInlineHandler.class);
    private static Logger log = Logger.getLogger(HRefInlineHandler.class);
    private SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
    private SOAPBodyImpl soapBody;

    public HRefInlineHandler(SOAPBodyImpl soapBody) {
        this.soapBody = soapBody;
    }

    public void processHRefs() throws SOAPException {
        String bodyStr = DOMWriter.printNode((org.w3c.dom.Node)((Object)this.soapBody), (boolean)true);
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug((Object)("Begin processHRefs:\n" + bodyStr));
        }
        SOAPBodyElement soapBodyElement = this.soapBody.getBodyElement();
        this.processElement((SOAPElement)soapBodyElement);
        Iterator<org.w3c.dom.Node> it = this.soapBody.getChildElements();
        while (it.hasNext()) {
            SOAPElement soapElement;
            org.w3c.dom.Node next = it.next();
            if (!(next instanceof SOAPElement) || (soapElement = (SOAPElement)next) instanceof SOAPBodyElement) continue;
            this.soapBody.removeChild((org.w3c.dom.Node)soapElement);
        }
        bodyStr = DOMWriter.printNode((org.w3c.dom.Node)((Object)this.soapBody), (boolean)true);
        if (debugEnabled) {
            log.debug((Object)("End processHRefs:\n" + bodyStr));
        }
    }

    private void processElement(SOAPElement soapElement) throws SOAPException {
        Iterator it = soapElement.getChildElements();
        while (it.hasNext()) {
            Node childElement = (Node)it.next();
            if (!(childElement instanceof SOAPElement)) continue;
            this.processElement((SOAPElement)childElement);
        }
        String href = soapElement.getAttribute("href");
        if (href.length() > 0) {
            this.processHRef(soapElement, href);
            soapElement.removeAttribute("href");
        }
    }

    private void processHRef(SOAPElement hrefElement, String href) throws SOAPException {
        SOAPElement idElement = null;
        Iterator<org.w3c.dom.Node> it = this.soapBody.getChildElements();
        while (it.hasNext()) {
            org.w3c.dom.Node next = it.next();
            if (!(next instanceof SOAPElement)) continue;
            SOAPElement auxElement = (SOAPElement)next;
            if (!href.equals("#" + auxElement.getAttribute("id"))) continue;
            idElement = auxElement;
            break;
        }
        if (idElement == null) {
            throw new IllegalStateException(BundleUtils.getMessage(bundle, "CANNOT_GET_HREF_ELEMENT", href));
        }
        this.processElement(idElement);
        this.copyMostAttributes((Element)hrefElement, (Element)idElement);
        if (DOMUtils.hasChildElements(idElement)) {
            Iterator itid = idElement.getChildElements();
            while (itid.hasNext()) {
                Node childNode = (Node)itid.next();
                if (childNode instanceof SOAPElement) {
                    SOAPElement childClone = this.soapFactory.createElement((Element)((SOAPElement)childNode), true);
                    hrefElement.addChildElement(childClone);
                    continue;
                }
                if (!(childNode instanceof Text)) continue;
                String value = childNode.getValue();
                hrefElement.setValue(value);
            }
        } else {
            String value = idElement.getValue();
            hrefElement.setValue(value);
        }
    }

    private void copyMostAttributes(Element destElement, Element srcElement) {
        NamedNodeMap attribs = srcElement.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String uri = attr.getNamespaceURI();
            String qname = attr.getName();
            String value = attr.getNodeValue();
            if ("id".equals(qname)) continue;
            destElement.setAttributeNS(uri, qname, value);
        }
    }
}

