/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.utils;

import java.util.ResourceBundle;
import org.jboss.ws.core.soap.BundleUtils;

public class Use {
    private static final ResourceBundle bundle = BundleUtils.getBundle(Use.class);
    private String use;
    public static final Use LITERAL = new Use("literal");
    public static final Use ENCODED = new Use("encoded");

    private Use(String use) {
        this.use = use;
    }

    public static Use getDefaultUse() {
        return LITERAL;
    }

    public static Use valueOf(String encodingStyle) {
        if ("".equals(encodingStyle) || Use.LITERAL.use.equals(encodingStyle)) {
            return LITERAL;
        }
        if ("http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle) || Use.ENCODED.use.equals(encodingStyle)) {
            return ENCODED;
        }
        throw new IllegalArgumentException(BundleUtils.getMessage(bundle, "UNSUPPORTED_ENCODING_STYLE", encodingStyle));
    }

    public String toURI() {
        String encURI = null;
        if (this == LITERAL) {
            encURI = "";
        } else if (this == ENCODED) {
            encURI = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return encURI;
    }

    public String toString() {
        return this.use;
    }
}

