/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.management.OperationAssociation;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

public class BundleActivateProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        XBundle bundle2 = (XBundle)depUnit.getAttachment(OSGiConstants.BUNDLE_KEY);
        if (bundle2 == null || bundle2.isFragment()) {
            return;
        }
        ServiceController<XBundle> controller = BundleActivateService.addService(phaseContext.getServiceTarget(), depUnit, bundle2);
        phaseContext.addDependency(controller.getName(), AttachmentKey.create(XBundle.class));
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    static class BundleActivateService
    implements Service<XBundle> {
        private final InjectedValue<XBundle> injectedBundle = new InjectedValue();
        private final InjectedValue<Component> injectedComponent = new InjectedValue();
        private final DeploymentUnit depUnit;

        static ServiceController<XBundle> addService(ServiceTarget serviceTarget, DeploymentUnit depUnit, XBundle bundle2) {
            BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
            ServiceName resolvedBundle = bundleManager.getServiceName(bundle2, 4);
            ServiceName serviceName = depUnit.getServiceName().append(new String[]{"Activate"});
            BundleActivateService service = new BundleActivateService(depUnit);
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
            builder.addDependency(resolvedBundle, XBundle.class, service.injectedBundle);
            OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
            if (metadata != null && metadata.getBundleActivator() != null) {
                String activatorClass = metadata.getBundleActivator();
                EEModuleDescription moduleDescription = (EEModuleDescription)depUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                    if (!activatorClass.equals(componentDescription.getComponentClassName())) continue;
                    ServiceName startServiceName = componentDescription.getStartServiceName();
                    builder.addDependency(startServiceName, Component.class, service.injectedComponent);
                }
            }
            return builder.install();
        }

        private BundleActivateService(DeploymentUnit depUnit) {
            this.depUnit = depUnit;
        }

        public void start(StartContext context) throws StartException {
            XBundle bundle2 = (XBundle)this.injectedBundle.getValue();
            Deployment deployment = (Deployment)this.depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
            Component activatorComponent = (Component)this.injectedComponent.getOptionalValue();
            if (activatorComponent != null && deployment.getAttachment(BundleActivator.class) == null) {
                ComponentInstance componentInstance = activatorComponent.createInstance();
                BundleActivator instance = (BundleActivator)componentInstance.getInstance();
                deployment.addAttachment(BundleActivator.class, (Object)instance);
            }
            OperationAssociation.INSTANCE.setAssociation(new ModelNode("deploy"));
            try {
                bundle2.start(2);
                this.depUnit.putAttachment(org.jboss.as.server.deployment.Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.ACTIVE);
            }
            catch (BundleException ex) {
                throw OSGiMessages.MESSAGES.cannotStartBundle(ex, (Bundle)bundle2);
            }
            finally {
                OperationAssociation.INSTANCE.removeAssociation();
            }
        }

        public void stop(StopContext context) {
            XBundle bundle2 = (XBundle)this.injectedBundle.getValue();
            try {
                bundle2.stop(1);
                this.depUnit.putAttachment(org.jboss.as.server.deployment.Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.RESOLVED);
            }
            catch (BundleException ex) {
                OSGiLogger.LOGGER.debugf(ex, "Cannot stop bundle: %s", bundle2);
            }
        }

        public XBundle getValue() {
            return (XBundle)this.injectedBundle.getValue();
        }
    }
}

