/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.InitialDeploymentTracker;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.framework.spi.StorageStatePlugin;
import org.osgi.framework.BundleException;

public class BundleInstallProcessor
implements DeploymentUnitProcessor {
    private final AttachmentKey<ServiceName> BUNDLE_INSTALL_SERVICE = AttachmentKey.create(ServiceName.class);
    private final InitialDeploymentTracker deploymentTracker;

    public BundleInstallProcessor(InitialDeploymentTracker deploymentTracker) {
        this.deploymentTracker = deploymentTracker;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceName serviceName;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Deployment deployment = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
        if (deployment == null) {
            return;
        }
        try {
            BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
            if (this.deploymentTracker.hasDeploymentName(depUnit.getName())) {
                this.restoreStorageState(phaseContext, deployment);
            }
            serviceName = bundleManager.installBundle(deployment, null);
        }
        catch (BundleException ex) {
            throw new DeploymentUnitProcessingException((Throwable)ex);
        }
        phaseContext.addDeploymentDependency(serviceName, OSGiConstants.BUNDLE_KEY);
        if (!this.deploymentTracker.isComplete()) {
            phaseContext.addDeploymentDependency(InitialDeploymentTracker.INITIAL_DEPLOYMENTS_COMPLETE, AttachmentKey.create(Object.class));
        }
        depUnit.putAttachment(Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.INSTALLED);
        depUnit.putAttachment(this.BUNDLE_INSTALL_SERVICE, (Object)serviceName);
    }

    public void undeploy(DeploymentUnit depUnit) {
        ServiceController controller;
        ServiceName serviceName = (ServiceName)depUnit.getAttachment(this.BUNDLE_INSTALL_SERVICE);
        ServiceController serviceController = controller = serviceName != null ? depUnit.getServiceRegistry().getService(serviceName) : null;
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
            depUnit.putAttachment(Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.UNINSTALLED);
        }
    }

    private void restoreStorageState(DeploymentPhaseContext phaseContext, Deployment deployment) {
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        StorageStatePlugin storageProvider = (StorageStatePlugin)serviceRegistry.getRequiredService(IntegrationServices.STORAGE_STATE_PLUGIN).getValue();
        StorageState storageState = storageProvider.getStorageState(deployment.getLocation());
        if (storageState != null) {
            deployment.setAutoStart(storageState.isPersistentlyStarted());
            deployment.addAttachment(StorageState.class, (Object)storageState);
        }
    }
}

