/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;

public class DeferredPhaseProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        XBundle bundle2 = (XBundle)depUnit.getAttachment(OSGiConstants.BUNDLE_KEY);
        if (bundle2 == null || bundle2.isFragment()) {
            return;
        }
        BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
        ServiceName bundleResolve = bundleManager.getServiceName(bundle2, 4);
        phaseContext.addDeploymentDependency(bundleResolve, AttachmentKey.create(Object.class));
        XBundleRevision brev = bundle2.getBundleRevision();
        ServiceName moduleService = ServiceModuleLoader.moduleServiceName((ModuleIdentifier)brev.getModuleIdentifier());
        phaseContext.addDeploymentDependency(moduleService, Attachments.MODULE);
        if (!bundle2.isResolved()) {
            depUnit.putAttachment(Attachments.DEFERRED_ACTIVATION_COUNT, (Object)new AtomicInteger());
            DeploymentUtils.addDeferredModule((DeploymentUnit)depUnit);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

