/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.osgi.parser.FrameworkCapabilityResource;
import org.jboss.as.osgi.parser.FrameworkPropertyResource;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.Namespace10;
import org.jboss.as.osgi.parser.Namespace11;
import org.jboss.as.osgi.parser.OSGiRootResource;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class OSGiNamespace10Parser
implements Namespace10,
XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static XMLElementReader<List<ModelNode>> INSTANCE = new OSGiNamespace10Parser();

    private OSGiNamespace10Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "osgi");
        address.protect();
        ModelNode activation = this.parseActivationAttribute(reader, address);
        operations.add(activation);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONFIGURATION: {
                            this.parseConfigurations(reader);
                            continue block8;
                        }
                        case PROPERTIES: {
                            List<ModelNode> result = this.parseFrameworkProperties(reader, address, operations);
                            operations.addAll(result);
                            continue block8;
                        }
                        case MODULES: {
                            List<ModelNode> result = this.parseModules(reader, address);
                            operations.addAll(result);
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseActivationAttribute(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ModelNode result = new ModelNode();
        result.get("operation").set("add");
        result.get("address").set(address);
        switch (Namespace.forUri(reader.getNamespaceURI())) {
            case VERSION_1_0: {
                int count = reader.getAttributeCount();
                block6: for (int i = 0; i < count; ++i) {
                    ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                    String attrValue = reader.getAttributeValue(i);
                    Namespace10.Attribute attribute = Namespace10.Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case ACTIVATION: {
                            OSGiRootResource.ACTIVATION.parseAndSetParameter(attrValue, result, (XMLStreamReader)reader);
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        return result;
    }

    private void parseConfigurations(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Namespace11.Attribute attribute = Namespace11.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PID: {
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    if (element == Namespace10.Element.PROPERTY) {
                        count = reader.getAttributeCount();
                        block11: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            Namespace10.Attribute attribute = Namespace10.Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    continue block11;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        reader.getElementText().trim();
                        continue block10;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private List<ModelNode> parseFrameworkProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    if (element == Namespace10.Element.PROPERTY) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String attrValue = reader.getAttributeValue(i);
                            Namespace10.Attribute attribute = Namespace10.Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace10.Attribute.NAME));
                        }
                        value = reader.getElementText().trim();
                        ModelNode propNode = new ModelNode();
                        propNode.get("operation").set("add");
                        propNode.get("address").set(address).add("property", name);
                        FrameworkPropertyResource.VALUE.parseAndSetParameter(value, propNode, (XMLStreamReader)reader);
                        result.add(propNode);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return result;
    }

    private List<ModelNode> parseModules(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ArrayList<ModelNode> nodes = new ArrayList<ModelNode>();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    if (element == Namespace10.Element.MODULE) {
                        int count = reader.getAttributeCount();
                        ModelNode moduleNode = new ModelNode();
                        moduleNode.get("operation").set("add");
                        block8: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            Namespace10.Attribute attribute = Namespace10.Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case IDENTIFIER: {
                                    moduleNode.get("address").set(address).add("capability", reader.getAttributeValue(i));
                                    continue block8;
                                }
                                case STARTLEVEL: {
                                    FrameworkCapabilityResource.STARTLEVEL.parseAndSetParameter(reader.getAttributeValue(i), moduleNode, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (!moduleNode.hasDefined("address")) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace10.Attribute.NAME));
                        }
                        nodes.add(moduleNode);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return nodes;
    }
}

