/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.management.OperationAssociation;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.client.ModelControllerServerDeploymentManager;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public final class BundleLifecycleIntegration
extends AbstractIntegrationService<BundleLifecyclePlugin>
implements BundleLifecyclePlugin {
    private static Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private ServerDeploymentManager deploymentManager;

    BundleLifecycleIntegration() {
        super(IntegrationServices.BUNDLE_LIFECYCLE_PLUGIN);
    }

    protected void addServiceDependencies(ServiceBuilder<BundleLifecyclePlugin> builder) {
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.injectedController);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        this.deploymentManager = new ModelControllerServerDeploymentManager((ModelController)this.injectedController.getValue());
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public BundleLifecyclePlugin getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment getDeployment(String runtimeName) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.get(runtimeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDeployment(String runtimeName, Deployment dep) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            deploymentMap.put(runtimeName, dep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment removeDeployment(String runtimeName) {
        Map<String, Deployment> map = deploymentMap;
        synchronized (map) {
            return deploymentMap.remove(runtimeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(Deployment dep, BundleLifecyclePlugin.DefaultHandler handler) throws BundleException {
        if (OperationAssociation.INSTANCE.getAssociation() != null) {
            OSGiLogger.LOGGER.warnCannotDeployBundleFromManagementOperation(dep);
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleManager.installBundle(dep, null);
        } else {
            OSGiLogger.LOGGER.debugf("Install deployment: %s", dep);
            String runtimeName = this.getRuntimeName(dep);
            this.putDeployment(runtimeName, dep);
            try {
                InputStream input = dep.getRoot().openStream();
                try {
                    ServerDeploymentHelper server = new ServerDeploymentHelper(this.deploymentManager);
                    server.deploy(runtimeName, input);
                }
                finally {
                    VFSUtils.safeClose((Closeable)input);
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw OSGiMessages.MESSAGES.cannotDeployBundle(ex, dep);
            }
        }
    }

    public void start(XBundle bundle2, int options, BundleLifecyclePlugin.DefaultHandler handler) throws BundleException {
        Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
        DeploymentUnit depUnit = (DeploymentUnit)deployment.getAttachment(DeploymentUnit.class);
        if (depUnit == null) {
            handler.start(bundle2, options);
            return;
        }
        List deferredModules = DeploymentUtils.getDeferredModules((DeploymentUnit)depUnit);
        if (!deferredModules.contains(depUnit.getName())) {
            handler.start(bundle2, options);
            return;
        }
        ServiceController<Phase> phaseService = this.getDeferredPhaseService(depUnit);
        if (phaseService.getMode() != ServiceController.Mode.NEVER) {
            handler.start(bundle2, options);
            return;
        }
        this.activateDeferredPhase(bundle2, depUnit, phaseService);
    }

    public void stop(XBundle bundle2, int options, BundleLifecyclePlugin.DefaultHandler handler) throws BundleException {
        handler.stop(bundle2, options);
    }

    public void uninstall(XBundle bundle2, BundleLifecyclePlugin.DefaultHandler handler) {
        OSGiLogger.LOGGER.tracef("Uninstall deployment: %s", bundle2);
        try {
            ServerDeploymentHelper server = new ServerDeploymentHelper(this.deploymentManager);
            Deployment dep = (Deployment)bundle2.adapt(Deployment.class);
            server.undeploy(this.getRuntimeName(dep));
        }
        catch (Exception ex) {
            OSGiLogger.LOGGER.warnCannotUndeployBundle(ex, (Bundle)bundle2);
        }
    }

    private void activateDeferredPhase(XBundle bundle2, DeploymentUnit depUnit, ServiceController<Phase> phaseService) throws BundleException {
        OSGiLogger.LOGGER.infoActivateDeferredModulePhase((Bundle)bundle2);
        final CountDownLatch latch = new CountDownLatch(1);
        ServiceTracker<Object> serviceTracker = new ServiceTracker<Object>(true){
            private final AtomicInteger count;
            {
                super(x0);
                this.count = new AtomicInteger();
            }

            public void serviceListenerAdded(ServiceController<? extends Object> controller) {
                OSGiLogger.LOGGER.debugf("Added: [%d] %s ", this.count.incrementAndGet(), controller.getName());
            }

            protected void serviceStarted(ServiceController<?> controller) {
                OSGiLogger.LOGGER.debugf("Started: [%d] %s ", this.count.decrementAndGet(), controller.getName());
            }

            protected void serviceStartFailed(ServiceController<?> controller) {
                OSGiLogger.LOGGER.debugf("Failed: [%d] %s ", this.count.decrementAndGet(), controller.getName());
            }

            protected void complete() {
                OSGiLogger.LOGGER.debugf("Complete: [%d]", this.count.get());
                latch.countDown();
            }
        };
        phaseService.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)serviceTracker);
        ((AtomicInteger)depUnit.getAttachment(Attachments.DEFERRED_ACTIVATION_COUNT)).incrementAndGet();
        phaseService.setMode(ServiceController.Mode.ACTIVE);
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (serviceTracker.hasFailedServices()) {
            StartException startex = null;
            for (ServiceController aux : serviceTracker.getFailedServices()) {
                if (aux.getStartException() == null) continue;
                startex = aux.getStartException();
                break;
            }
            BundleException failure = startex != null && startex.getCause() instanceof BundleException ? (BundleException)startex.getCause() : OSGiMessages.MESSAGES.cannotActivateDeferredModulePhase((Throwable)startex, (Bundle)bundle2);
            OSGiLogger.LOGGER.warnDeactivateDeferredModulePhase((Bundle)bundle2);
            phaseService.setMode(ServiceController.Mode.NEVER);
            try {
                FutureServiceValue future = new FutureServiceValue(phaseService, ServiceController.State.DOWN);
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                OSGiLogger.LOGGER.errorf(failure, failure.getMessage(), new Object[0]);
                throw OSGiMessages.MESSAGES.cannotDeactivateDeferredModulePhase(ex, (Bundle)bundle2);
            }
            catch (TimeoutException ex) {
                OSGiLogger.LOGGER.errorf(failure, failure.getMessage(), new Object[0]);
                throw OSGiMessages.MESSAGES.cannotDeactivateDeferredModulePhase(ex, (Bundle)bundle2);
            }
            throw failure;
        }
    }

    private String getRuntimeName(Deployment dep) {
        int idx;
        String name = dep.getLocation();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((idx = name.lastIndexOf("/")) > 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    private ServiceController<Phase> getDeferredPhaseService(DeploymentUnit depUnit) {
        ServiceName serviceName = DeploymentUtils.getDeploymentUnitPhaseServiceName((DeploymentUnit)depUnit, (Phase)Phase.FIRST_MODULE_USE);
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        ServiceContainer serviceContainer = bundleManager.getServiceContainer();
        return serviceContainer.getRequiredService(serviceName);
    }
}

