/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.Map;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.service.BundleReferenceClassLoader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.FrameworkModulePlugin;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.osgi.framework.Bundle;

final class FrameworkModuleIntegration
extends AbstractIntegrationService<FrameworkModulePlugin>
implements FrameworkModulePlugin {
    private final Map<String, Object> props;
    private Module frameworkModule;

    FrameworkModuleIntegration(Map<String, Object> props) {
        super(IntegrationServices.FRAMEWORK_MODULE_PLUGIN);
        this.props = props;
    }

    protected void addServiceDependencies(ServiceBuilder<FrameworkModulePlugin> builder) {
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
        this.frameworkModule = null;
    }

    public FrameworkModulePlugin getValue() throws IllegalStateException {
        return this;
    }

    public Module getFrameworkModule(Bundle systemBundle) {
        if (this.frameworkModule == null) {
            this.frameworkModule = this.createFrameworkModule(systemBundle);
        }
        return this.frameworkModule;
    }

    private Module createFrameworkModule(Bundle systemBundle) {
        String extramodules;
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.framework"));
        String sysmodules = (String)this.props.get("org.jboss.osgi.system.modules");
        if (sysmodules == null) {
            sysmodules = "";
        }
        if ((extramodules = (String)this.props.get("org.jboss.osgi.system.modules.extra")) != null) {
            sysmodules = sysmodules + "," + extramodules;
        }
        ModuleLoader bootLoader = Module.getBootModuleLoader();
        PathFilter acceptAll = PathFilters.acceptAll();
        for (String modid : sysmodules.split(",")) {
            if ((modid = modid.trim()).length() <= 0) continue;
            ModuleIdentifier identifier = ModuleIdentifier.create((String)modid);
            specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)acceptAll, (PathFilter)acceptAll, (ModuleLoader)bootLoader, (ModuleIdentifier)identifier, (boolean)false));
        }
        specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new BundleReferenceClassLoader.Factory(systemBundle));
        try {
            final ModuleSpec moduleSpec = specBuilder.create();
            ModuleLoader moduleLoader = new ModuleLoader(){

                protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                    return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                }

                public String toString() {
                    return "FrameworkModuleLoader";
                }
            };
            return moduleLoader.loadModule(specBuilder.getIdentifier());
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

