/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ModuleLoadService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ModuleLoaderPlugin;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XIdentityCapability;

final class ModuleLoaderIntegration
extends ModuleLoader
implements ModuleLoaderPlugin,
IntegrationService<ModuleLoaderPlugin> {
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;

    ModuleLoaderIntegration() {
    }

    public ServiceName getServiceName() {
        return IntegrationServices.MODULE_LOADER_PLUGIN;
    }

    public ServiceController<ModuleLoaderPlugin> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceBuilder builder = serviceTarget.addService(this.getServiceName(), (Service)this);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, this.injectedModuleLoader);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.addListener(listener);
        return builder.install();
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        this.serviceContainer = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public ModuleLoaderPlugin getValue() throws IllegalStateException {
        return this;
    }

    public ModuleLoader getModuleLoader() {
        return this;
    }

    public ModuleIdentifier getModuleIdentifier(XBundleRevision brev) {
        XBundle bundle2 = brev.getBundle();
        Deployment deployment = (Deployment)bundle2.adapt(Deployment.class);
        ModuleIdentifier identifier = (ModuleIdentifier)deployment.getAttachment(ModuleIdentifier.class);
        if (identifier == null) {
            XIdentityCapability icap = brev.getIdentityCapability();
            List allrevs = bundle2.getAllBundleRevisions();
            String name = icap.getSymbolicName();
            if (allrevs.size() > 1) {
                name = name + "-rev" + (allrevs.size() - 1);
            }
            identifier = ModuleIdentifier.create((String)("deployment." + name), (String)("" + icap.getVersion()));
        }
        return identifier;
    }

    public void addIntegrationDependencies(ModuleLoaderPlugin.ModuleSpecBuilderContext context) {
        ModuleSpec.Builder builder = context.getModuleSpecBuilder();
        XBundleRevision brev = context.getBundleRevision();
        Map moduleDependencies = context.getModuleDependencies();
        Deployment deployment = (Deployment)brev.getBundle().adapt(Deployment.class);
        ModuleSpecification moduleSpecification = (ModuleSpecification)deployment.getAttachment(ModuleSpecification.class);
        if (moduleSpecification != null) {
            List dependencies = moduleSpecification.getAllDependencies();
            OSGiLogger.LOGGER.debugf("Adding integration dependencies: %d", dependencies.size());
            for (ModuleDependency moduleDep : dependencies) {
                ModuleIdentifier moduleId = moduleDep.getIdentifier();
                if (moduleDependencies.get(moduleId) != null) {
                    OSGiLogger.LOGGER.debugf("  -dependency on %s (skipped)", moduleId);
                    continue;
                }
                MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder((boolean)true);
                for (FilterSpecification filter : moduleDep.getImportFilters()) {
                    importBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                }
                PathFilter importFilter = importBuilder.create();
                MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder((boolean)true);
                for (FilterSpecification filter : moduleDep.getExportFilters()) {
                    importBuilder.addFilter(filter.getPathFilter(), filter.isInclude());
                }
                PathFilter exportFilter = exportBuilder.create();
                ModuleLoader moduleLoader = moduleDep.getModuleLoader();
                boolean optional = moduleDep.isOptional();
                DependencySpec depSpec = DependencySpec.createModuleDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (ModuleLoader)moduleLoader, (ModuleIdentifier)moduleId, (boolean)optional);
                OSGiLogger.LOGGER.debugf("  +%s", depSpec);
                builder.addDependency(depSpec);
            }
        }
    }

    public void addModuleSpec(XBundleRevision brev, ModuleSpec moduleSpec) {
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        OSGiLogger.LOGGER.tracef("Add module spec to loader: %s", identifier);
        ServiceName moduleSpecName = ServiceModuleLoader.moduleSpecServiceName((ModuleIdentifier)identifier);
        ImmediateValue value = new ImmediateValue((Object)moduleSpec);
        this.serviceTarget.addService(moduleSpecName, (Service)new ValueService((Value)value)).install();
    }

    public void addModule(XBundleRevision brev, Module module) {
        ServiceName moduleServiceName = this.getModuleServiceName(module.getIdentifier());
        if (this.serviceContainer.getService(moduleServiceName) == null) {
            OSGiLogger.LOGGER.debugf("Add module to loader: %s", module.getIdentifier());
            this.serviceTarget.addService(moduleServiceName, (Service)new ValueService((Value)new ImmediateValue((Object)module))).install();
        }
    }

    public ServiceName createModuleService(XBundleRevision brev, ModuleIdentifier identifier) {
        List dependencies = Collections.emptyList();
        return ModuleLoadService.install((ServiceTarget)this.serviceTarget, (ModuleIdentifier)identifier, dependencies);
    }

    public void removeModule(XBundleRevision brev, ModuleIdentifier identifier) {
        HashSet<ServiceName> serviceNames = new HashSet<ServiceName>();
        serviceNames.add(this.getModuleSpecServiceName(identifier));
        serviceNames.add(this.getModuleServiceName(identifier));
        for (ServiceName serviceName : serviceNames) {
            ServiceController controller = this.serviceContainer.getService(serviceName);
            if (controller == null) continue;
            OSGiLogger.LOGGER.debugf("Remove from loader: %s", serviceName);
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ModuleSpec moduleSpec = ((ServiceModuleLoader)this.injectedModuleLoader.getValue()).findModule(identifier);
        if (moduleSpec == null) {
            OSGiLogger.LOGGER.debugf("Cannot obtain module spec for: %s", identifier);
        }
        return moduleSpec;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = ModuleLoader.preloadModule((ModuleIdentifier)identifier, (ModuleLoader)((ModuleLoader)this.injectedModuleLoader.getValue()));
        if (module == null) {
            OSGiLogger.LOGGER.debugf("Cannot obtain module for: %s", identifier);
        }
        return module;
    }

    public void setAndRelinkDependencies(Module module, List<DependencySpec> dependencies) throws ModuleLoadException {
        throw new UnsupportedOperationException();
    }

    public ServiceName getModuleServiceName(ModuleIdentifier identifier) {
        return ServiceModuleLoader.moduleServiceName((ModuleIdentifier)identifier);
    }

    private ServiceName getModuleSpecServiceName(ModuleIdentifier identifier) {
        return ServiceModuleLoader.moduleSpecServiceName((ModuleIdentifier)identifier);
    }

    public String toString() {
        return ModuleLoaderIntegration.class.getSimpleName();
    }
}

