/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkCoreServices;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.BundleLock;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

abstract class AbstractBundleState
extends AbstractElement
implements XBundle {
    private final long bundleId;
    private final String symbolicName;
    private final FrameworkState frameworkState;
    private final BundleLock bundleLock = new BundleLock();
    private final AtomicInteger bundleState = new AtomicInteger(1);
    private final List<ServiceState> registeredServices = new CopyOnWriteArrayList<ServiceState>();
    private final ConcurrentHashMap<ServiceState, AtomicInteger> usedServices = new ConcurrentHashMap();
    private ResolutionException lastResolutionException;
    private BundleStateRevision currentRevision;
    private AbstractBundleContext bundleContext;

    AbstractBundleState(FrameworkState frameworkState, BundleStateRevision brev, long bundleId) {
        assert (frameworkState != null) : "Null frameworkState";
        assert (brev != null) : "Null revision";
        String symbolicName = brev.getOSGiMetaData().getBundleSymbolicName();
        if (symbolicName != null && symbolicName.indexOf(59) > 0) {
            symbolicName = symbolicName.substring(0, symbolicName.indexOf(59));
        }
        this.bundleId = bundleId;
        this.symbolicName = symbolicName;
        this.frameworkState = frameworkState;
        brev.addAttachment(Bundle.class, (Object)this);
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.frameworkState.getBundleManager();
    }

    SystemBundleState getSystemBundle() {
        return this.frameworkState.getSystemBundle();
    }

    FrameworkCoreServices getCoreServices() {
        return this.frameworkState.getCoreServices();
    }

    public int getState() {
        return this.bundleState.get();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    abstract AbstractBundleContext createContextInternal();

    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (type.isAssignableFrom(OSGiMetaData.class)) {
            result = this.getOSGiMetaData();
        } else if (type.isAssignableFrom(StorageState.class)) {
            result = this.getStorageState();
        } else if (type.isAssignableFrom(BundleManager.class)) {
            result = this.getBundleManager();
        }
        return (T)result;
    }

    public BundleStateRevision getBundleRevision() {
        return this.currentRevision;
    }

    void addBundleRevision(BundleStateRevision rev) {
        rev.addAttachment(Bundle.class, (Object)this);
        this.currentRevision = rev;
    }

    abstract BundleStateRevision getBundleRevisionById(int var1);

    abstract ServiceName getServiceName(int var1);

    abstract boolean isSingleton();

    BundleStoragePlugin.InternalStorageState getStorageState() {
        return this.getBundleRevision().getStorageState();
    }

    ModuleIdentifier getModuleIdentifier() {
        return this.getBundleRevision().getModuleIdentifier();
    }

    void changeState(int state) {
        int bundleEvent;
        switch (state) {
            case 8: {
                bundleEvent = 128;
                break;
            }
            case 32: {
                bundleEvent = 2;
                break;
            }
            case 16: {
                bundleEvent = 256;
                break;
            }
            case 1: {
                bundleEvent = 16;
                break;
            }
            case 2: {
                bundleEvent = 1;
                break;
            }
            case 4: {
                bundleEvent = 32;
                break;
            }
            default: {
                throw FrameworkMessages.MESSAGES.illegalArgumentUnknownBundleState(state);
            }
        }
        this.changeState(state, bundleEvent);
    }

    void changeState(int state, int eventType) {
        FrameworkLogger.LOGGER.tracef("changeState: %s -> %s", (Object)this, ConstantsHelper.bundleState((int)state));
        boolean frameworkActive = this.getBundleManager().isFrameworkCreated();
        if (frameworkActive && this.getBundleId() > 0L) {
            LifecycleInterceptorPlugin plugin = this.getCoreServices().getLifecycleInterceptorPlugin();
            plugin.handleStateChange(state, (Bundle)this);
        }
        this.bundleState.set(state);
        if (frameworkActive && eventType != 0) {
            this.fireBundleEvent(eventType);
        }
    }

    void fireBundleEvent(int eventType) {
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(this, eventType);
    }

    void addRegisteredService(ServiceState serviceState) {
        FrameworkLogger.LOGGER.tracef("Add registered service %s to: %s", serviceState, (Object)this);
        this.registeredServices.add(serviceState);
    }

    void removeRegisteredService(ServiceState serviceState) {
        FrameworkLogger.LOGGER.tracef("Remove registered service %s from: %s", serviceState, (Object)this);
        this.registeredServices.remove(serviceState);
    }

    public ServiceReference[] getRegisteredServices() {
        this.assertNotUninstalled();
        List<ServiceState> rs = this.getRegisteredServicesInternal();
        if (rs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : rs) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    List<ServiceState> getRegisteredServicesInternal() {
        return Collections.unmodifiableList(this.registeredServices);
    }

    public ServiceReference[] getServicesInUse() {
        this.assertNotUninstalled();
        Set<ServiceState> servicesInUse = this.getServicesInUseInternal();
        if (servicesInUse.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : servicesInUse) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    Set<ServiceState> getServicesInUseInternal() {
        return Collections.unmodifiableSet(this.usedServices.keySet());
    }

    void addServiceInUse(ServiceState serviceState) {
        FrameworkLogger.LOGGER.tracef("Add service in use %s to: %s", serviceState, (Object)this);
        this.usedServices.putIfAbsent(serviceState, new AtomicInteger());
        AtomicInteger count = this.usedServices.get(serviceState);
        count.incrementAndGet();
    }

    int removeServiceInUse(ServiceState serviceState) {
        FrameworkLogger.LOGGER.tracef("Remove service in use %s from: %s", serviceState, (Object)this);
        AtomicInteger count = this.usedServices.get(serviceState);
        if (count == null) {
            return -1;
        }
        int countVal = count.decrementAndGet();
        if (countVal == 0) {
            this.usedServices.remove(serviceState);
        }
        return countVal;
    }

    public boolean hasPermission(Object permission) {
        if (permission == null || !(permission instanceof Permission)) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        return true;
    }

    public URL getResource(String name) {
        return this.getBundleRevision().getResource(name);
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        URL entryURL;
        String baseName;
        Dictionary rawHeaders = this.getOSGiMetaData().getHeaders();
        if ("".equals(locale)) {
            return rawHeaders;
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        if ((baseName = (String)rawHeaders.get("Bundle-Localization")) == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((entryURL = this.getLocalizationEntry(baseName, locale)) == null) {
            String defaultLocale = Locale.getDefault().toString();
            entryURL = this.getLocalizationEntry(baseName, defaultLocale);
        }
        PropertyResourceBundle resBundle = null;
        if (entryURL != null) {
            try {
                resBundle = new PropertyResourceBundle(entryURL.openStream());
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotReadResourceBundle(ex, entryURL);
            }
        }
        Hashtable<String, String> locHeaders = new Hashtable<String, String>();
        Enumeration e = rawHeaders.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)rawHeaders.get(key);
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (resBundle != null) {
                try {
                    value = resBundle.getString(value);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            ((Dictionary)locHeaders).put(key, value);
        }
        return new CaseInsensitiveDictionary(locHeaders);
    }

    OSGiMetaData getOSGiMetaData() {
        return this.getBundleRevision().getOSGiMetaData();
    }

    public boolean isResolved() {
        return this.getBundleRevision().getWiring() != null;
    }

    boolean isUninstalled() {
        return this.getState() == 1;
    }

    private URL getLocalizationEntry(String baseName, String locale) {
        String entryPath = baseName + "_" + locale + ".properties";
        URL entryURL = this.getLocalizationEntry(entryPath);
        while (entryURL == null && !entryPath.equals(baseName + ".properties")) {
            int lastIndex = locale.lastIndexOf(95);
            if (lastIndex > 0) {
                locale = locale.substring(0, lastIndex);
                entryPath = baseName + "_" + locale + ".properties";
            } else {
                entryPath = baseName + ".properties";
            }
            entryURL = this.getLocalizationEntry(entryPath);
        }
        return entryURL;
    }

    private URL getLocalizationEntry(String entryPath) {
        return this.getBundleRevision().getLocalizationEntry(entryPath);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        this.assertNotUninstalled();
        return this.getBundleRevision().loadClass(className);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getBundleRevision().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.getBundleRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getBundleRevision().getEntry(path);
    }

    public long getLastModified() {
        return this.getStorageState().getLastModified();
    }

    void updateLastModified() {
        this.getStorageState().updateLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return this.getBundleRevision().findEntries(path, filePattern, recurse);
    }

    AbstractBundleContext getBundleContextInternal() {
        return this.bundleContext;
    }

    AbstractBundleContext createBundleContext() {
        assert (this.bundleContext == null) : "BundleContext already available";
        this.bundleContext = this.createContextInternal();
        return this.bundleContext;
    }

    void destroyBundleContext() {
        if (this.bundleContext != null) {
            this.bundleContext.destroy();
            this.bundleContext = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Map getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    public Version getVersion() {
        return this.getBundleRevision().getVersion();
    }

    public void start() throws BundleException {
        this.assertNotUninstalled();
        this.startInternal(0);
    }

    public void start(int options) throws BundleException {
        this.assertNotUninstalled();
        this.startInternal(options);
    }

    abstract void startInternal(int var1) throws BundleException;

    public void stop() throws BundleException {
        this.assertNotUninstalled();
        this.stopInternal(0);
    }

    public void stop(int options) throws BundleException {
        this.assertNotUninstalled();
        this.stopInternal(options);
    }

    abstract void stopInternal(int var1) throws BundleException;

    public void update() throws BundleException {
        this.assertNotUninstalled();
        this.updateInternal(null);
        FrameworkLogger.LOGGER.infoBundleUpdated((Bundle)this);
        this.updateLastModified();
    }

    public void update(InputStream input) throws BundleException {
        this.assertNotUninstalled();
        this.updateInternal(input);
        FrameworkLogger.LOGGER.infoBundleUpdated((Bundle)this);
        this.updateLastModified();
    }

    abstract void updateInternal(InputStream var1) throws BundleException;

    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        this.uninstallInternal();
    }

    abstract void uninstallInternal() throws BundleException;

    boolean aquireBundleLock(BundleLock.LockMethod method) {
        return this.bundleLock.tryLock(this, method);
    }

    void releaseBundleLock(BundleLock.LockMethod method) {
        this.bundleLock.unlock(this, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureResolved(boolean fireEvent) {
        boolean result;
        block11: {
            if (this.isUninstalled()) {
                throw FrameworkMessages.MESSAGES.illegalStateBundleAlreadyUninstalled((Bundle)this);
            }
            result = false;
            if (this.aquireBundleLock(BundleLock.LockMethod.RESOLVE)) {
                try {
                    result = true;
                    if (this.isResolved()) break block11;
                    try {
                        ResolverPlugin resolverPlugin = this.getFrameworkState().getResolverPlugin();
                        Set<BundleStateRevision> mandatory = Collections.singleton(this.getBundleRevision());
                        resolverPlugin.resolveAndApply(mandatory, null);
                        if (FrameworkLogger.LOGGER.isDebugEnabled()) {
                            BundleWiring wiring = this.getBundleRevision().getWiring();
                            FrameworkLogger.LOGGER.tracef("Required resource wires for: %s", wiring.getResource());
                            for (Wire wire : wiring.getRequiredResourceWires(null)) {
                                FrameworkLogger.LOGGER.tracef("   %s", wire);
                            }
                            FrameworkLogger.LOGGER.tracef("Provided resource wires for: %s", wiring.getResource());
                            for (Wire wire : wiring.getProvidedResourceWires(null)) {
                                FrameworkLogger.LOGGER.tracef("   %s", wire);
                            }
                        }
                    }
                    catch (ResolutionException ex) {
                        this.lastResolutionException = ex;
                        result = false;
                        if (fireEvent) {
                            FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
                            eventsPlugin.fireFrameworkEvent((Bundle)this, 2, new BundleException(ex.getMessage(), (Throwable)ex));
                        }
                    }
                }
                finally {
                    this.releaseBundleLock(BundleLock.LockMethod.RESOLVE);
                }
            }
        }
        return result;
    }

    ResolutionException getLastResolutionException() {
        return this.lastResolutionException;
    }

    void assertNotUninstalled() {
        if (this.isUninstalled()) {
            throw FrameworkMessages.MESSAGES.illegalStateBundleAlreadyUninstalled((Bundle)this);
        }
    }

    static AbstractBundleState assertBundleState(Bundle bundle2) {
        assert (bundle2 != null) : "Null bundle";
        assert (bundle2 instanceof AbstractBundleState) : "Not a BundleState: " + bundle2;
        return (AbstractBundleState)bundle2;
    }

    public String getCanonicalName() {
        OSGiMetaData metadata = this.getOSGiMetaData();
        String name = metadata.getBundleSymbolicName();
        name = name != null ? name : metadata.getBundleName();
        return name + ":" + metadata.getBundleVersion();
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBundle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XBundle other = (XBundle)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

