/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleInstalledService;
import org.jboss.osgi.framework.internal.FrameworkCoreServices;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleActiveService;
import org.jboss.osgi.framework.internal.HostBundleInstalledService;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.Java;
import org.jboss.osgi.framework.internal.LockManagerPlugin;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.SecurityActions;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleLock;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.ConstantsHelper;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.Version;

final class BundleManagerPlugin
extends AbstractIntegrationService<BundleManager>
implements BundleManager {
    private static String OSGi_FRAMEWORK_EXECUTIONENVIRONMENT;
    private static String OSGi_FRAMEWORK_LANGUAGE;
    private static String OSGi_FRAMEWORK_OS_NAME;
    private static String OSGi_FRAMEWORK_OS_VERSION;
    private static String OSGi_FRAMEWORK_PROCESSOR;
    private static String OSGi_FRAMEWORK_VENDOR;
    private static String OSGi_FRAMEWORK_VERSION;
    private static String implementationVersion;
    final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    final InjectedValue<LockManagerPlugin> injectedLockManager = new InjectedValue();
    final InjectedValue<Boolean> injectedFrameworkActive = new InjectedValue();
    private final FrameworkBuilder frameworkBuilder;
    private final ShutdownContainer shutdownContainer;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final AtomicInteger managerState = new AtomicInteger(2);
    private final AtomicBoolean managerStopped = new AtomicBoolean();
    private final ServiceContainer serviceContainer;
    private SystemBundleState cachedSystemBundle;
    private ServiceTarget serviceTarget;
    private int stoppedEvent;

    BundleManagerPlugin(ServiceContainer serviceContainer, FrameworkBuilder frameworkBuilder) {
        super(Services.BUNDLE_MANAGER);
        this.serviceContainer = serviceContainer;
        this.frameworkBuilder = frameworkBuilder;
        this.stoppedEvent = 64;
        this.properties.putAll(frameworkBuilder.getProperties());
        if (this.getProperty("org.osgi.framework.executionenvironment") == null) {
            this.setProperty("org.osgi.framework.executionenvironment", OSGi_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (this.getProperty("org.osgi.framework.language") == null) {
            this.setProperty("org.osgi.framework.language", OSGi_FRAMEWORK_LANGUAGE);
        }
        if (this.getProperty("org.osgi.framework.os.name") == null) {
            this.setProperty("org.osgi.framework.os.name", OSGi_FRAMEWORK_OS_NAME);
        }
        if (this.getProperty("org.osgi.framework.os.version") == null) {
            this.setProperty("org.osgi.framework.os.version", OSGi_FRAMEWORK_OS_VERSION);
        }
        if (this.getProperty("org.osgi.framework.processor") == null) {
            this.setProperty("org.osgi.framework.processor", OSGi_FRAMEWORK_PROCESSOR);
        }
        if (this.getProperty("org.osgi.framework.vendor") == null) {
            this.setProperty("org.osgi.framework.vendor", OSGi_FRAMEWORK_VENDOR);
        }
        if (this.getProperty("org.osgi.framework.version") == null) {
            this.setProperty("org.osgi.framework.version", OSGi_FRAMEWORK_VERSION);
        }
        boolean allowContainerShutdown = frameworkBuilder.getServiceContainer() == null;
        this.shutdownContainer = new ShutdownContainer(serviceContainer, allowContainerShutdown);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<BundleManager> builder) {
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(InternalServices.LOCK_MANAGER_PLUGIN, LockManagerPlugin.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        FrameworkLogger.LOGGER.infoFrameworkImplementation(implementationVersion);
        this.serviceTarget = context.getChildTarget();
        FrameworkLogger.LOGGER.debugf("Framework properties", new Object[0]);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            FrameworkLogger.LOGGER.debugf(" %s = %s", entry.getKey(), entry.getValue());
        }
    }

    public BundleManagerPlugin getValue() throws IllegalStateException {
        return this;
    }

    FrameworkBuilder getFrameworkBuilder() {
        return this.frameworkBuilder;
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    @Override
    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public SystemBundleState getSystemBundle() {
        return (SystemBundleState)((Object)this.injectedSystemBundle.getOptionalValue());
    }

    boolean isFrameworkCreated() {
        return this.getFrameworkState() != null;
    }

    void assertFrameworkCreated() {
        if (!this.isFrameworkCreated()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkNotActive();
        }
    }

    @Override
    public boolean isFrameworkActive() {
        return Boolean.TRUE.equals(this.injectedFrameworkActive.getOptionalValue());
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getOptionalValue();
    }

    static Version getFrameworkVersion() {
        String versionSpec = BundleManagerPlugin.class.getPackage().getImplementationVersion();
        return Version.parseVersion((String)versionSpec);
    }

    int getManagerState() {
        return this.managerState.get();
    }

    void setManagerState(int state) {
        this.managerState.set(state);
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = SecurityActions.getSystemProperty(key, null);
        }
        return value;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            m.put(entry.getKey().toString(), entry.getValue());
        }
        m.putAll(this.properties);
        return m;
    }

    void setProperty(String key, Object value) {
        if (this.isFrameworkCreated()) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotAddProperty();
        }
        this.properties.put(key, value);
    }

    Set<XBundle> getBundles() {
        HashSet<XBundle> result = new HashSet<XBundle>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource aux : env.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            XBundle bundle2 = ((XBundleRevision)aux).getBundle();
            if (bundle2.getState() == 1) continue;
            result.add(bundle2);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<XBundle> getBundles(Integer states) {
        HashSet<XBundle> result = new HashSet<XBundle>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource aux : env.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            XBundle bundle2 = ((XBundleRevision)aux).getBundle();
            if (states != null && (bundle2.getState() & states) == 0) continue;
            result.add(bundle2);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public XBundle getBundleById(long bundleId) {
        if (bundleId == 0L) {
            return this.getFrameworkState().getSystemBundle();
        }
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        Collection resources = env.getResources(XEnvironment.ALL_IDENTITY_TYPES);
        for (XResource aux : resources) {
            XBundle bundle2 = ((XBundleRevision)aux).getBundle();
            if (bundle2.getBundleId() != bundleId) continue;
            return bundle2;
        }
        return null;
    }

    @Override
    public XBundle getBundleByLocation(String location) {
        assert (location != null) : "Null location";
        for (XBundle aux : this.getBundles()) {
            String auxLocation = aux.getLocation();
            if (!location.equals(auxLocation)) continue;
            return aux;
        }
        return null;
    }

    @Override
    public Set<XBundle> getBundles(String symbolicName, String versionRange) {
        HashSet<XBundle> resultSet = new HashSet<XBundle>();
        for (XBundle aux : this.getBundles(null)) {
            if (symbolicName != null && !symbolicName.equals(aux.getSymbolicName()) || versionRange != null && !VersionRange.parse((String)versionRange).isInRange(aux.getVersion())) continue;
            resultSet.add(aux);
        }
        return Collections.unmodifiableSet(resultSet);
    }

    @Override
    public ServiceName installBundle(Deployment dep, ServiceListener<XBundle> listener) throws BundleException {
        ServiceName serviceName;
        if (dep == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("deployment");
        }
        XBundle bundle2 = this.getBundleByLocation(dep.getLocation());
        if (bundle2 instanceof AbstractBundleState) {
            FrameworkLogger.LOGGER.debugf("Installing an already existing bundle: %s", dep);
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
            serviceName = bundleState.getServiceName(2);
            VFSUtils.safeClose((Closeable)dep.getRoot());
        } else {
            try {
                Long bundleId;
                String symbolicName = dep.getSymbolicName();
                XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
                StorageState storageState = (StorageState)dep.getAttachment(StorageState.class);
                if (storageState != null) {
                    FrameworkLogger.LOGGER.debugf("Found storage state: %s", storageState);
                    bundleId = env.nextResourceIdentifier(Long.valueOf(storageState.getBundleId()), symbolicName);
                } else {
                    bundleId = env.nextResourceIdentifier(null, symbolicName);
                }
                dep.addAttachment(Long.class, (Object)bundleId);
                OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
                if (metadata == null) {
                    DeploymentFactoryPlugin plugin = this.getFrameworkState().getDeploymentFactoryPlugin();
                    metadata = plugin.createOSGiMetaData(dep);
                }
                if (metadata.getFragmentHost() == null) {
                    serviceName = HostBundleInstalledService.addService(this.serviceTarget, this.getFrameworkState(), dep, listener);
                    HostBundleActiveService.addService(this.serviceTarget, this.getFrameworkState(), dep);
                } else {
                    serviceName = FragmentBundleInstalledService.addService(this.serviceTarget, this.getFrameworkState(), dep, listener);
                }
            }
            catch (RuntimeException rte) {
                VFSUtils.safeClose((Closeable)dep.getRoot());
                throw rte;
            }
            catch (BundleException ex) {
                VFSUtils.safeClose((Closeable)dep.getRoot());
                throw ex;
            }
        }
        dep.addAttachment(ServiceName.class, (Object)serviceName);
        return serviceName;
    }

    @Override
    public void uninstallBundle(Deployment dep) {
        Bundle bundle2 = (Bundle)dep.getAttachment(Bundle.class);
        UserBundleState userBundle = UserBundleState.assertBundleState(bundle2);
        this.uninstallBundle(userBundle, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(UserBundleState userBundle, int options) {
        if (userBundle.aquireBundleLock(BundleLock.LockMethod.UNINSTALL)) {
            try {
                int state = userBundle.getState();
                if (state == 1) {
                    return;
                }
                if (!(userBundle.isFragment() || state != 32 && state != 8 && state != 16)) {
                    try {
                        userBundle.stopInternal(options);
                    }
                    catch (Exception ex) {
                        this.fireFrameworkError((Bundle)userBundle, "stopping bundle: " + (Object)((Object)userBundle), ex);
                    }
                }
                FrameworkEventsPlugin eventsPlugin = userBundle.getFrameworkState().getFrameworkEventsPlugin();
                userBundle.changeState(1, 0);
                userBundle.removeServices();
                boolean hasActiveWires = userBundle.hasActiveWires();
                if (!hasActiveWires) {
                    this.removeBundle(userBundle, options);
                }
                eventsPlugin.fireBundleEvent(userBundle, 16);
                FrameworkLogger.LOGGER.infoBundleUninstalled((Bundle)userBundle);
                Set<XBundle> uninstalled = this.getBundles(1);
                for (XBundle auxState : uninstalled) {
                    UserBundleState auxUser = UserBundleState.assertBundleState((Bundle)auxState);
                    if (auxUser.hasActiveWires()) continue;
                    this.removeBundle(auxUser, options);
                }
            }
            finally {
                userBundle.releaseBundleLock(BundleLock.LockMethod.UNINSTALL);
            }
        }
    }

    void removeBundle(UserBundleState userBundle, int options) {
        FrameworkLogger.LOGGER.tracef("Start removing bundle: %s", (Object)userBundle);
        if ((options & 1) == 0) {
            BundleStoragePlugin storagePlugin = this.getFrameworkState().getBundleStoragePlugin();
            storagePlugin.deleteStorageState(userBundle.getStorageState());
        }
        XEnvironment env = this.getFrameworkState().getEnvironment();
        for (XBundleRevision abr : userBundle.getAllBundleRevisions()) {
            env.uninstallResources(new XResource[]{abr});
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.fireBundleEvent(userBundle, 64);
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        for (XBundleRevision brev : userBundle.getAllBundleRevisions()) {
            UserBundleRevision userRev = (UserBundleRevision)brev;
            if (!userRev.isFragment()) {
                ModuleIdentifier identifier = moduleManager.getModuleIdentifier(brev);
                moduleManager.removeModule(brev, identifier);
            }
            userRev.close();
        }
        FrameworkLogger.LOGGER.debugf("Removed bundle: %s", (Object)userBundle);
    }

    @Override
    public ServiceName getServiceName(XBundle bundle2, int state) {
        ServiceName result = null;
        if (bundle2 instanceof AbstractBundleState) {
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            result = bundleState.getServiceName(state);
        }
        return result;
    }

    @Override
    public ServiceName getServiceName(Deployment dep, int state) {
        Long bundleId = (Long)dep.getAttachment(Long.class);
        ServiceName serviceName = ServiceName.of((ServiceName)InternalServices.BUNDLE_BASE_NAME, (String[])new String[]{"" + bundleId, "" + dep.getSymbolicName(), "" + dep.getVersion()});
        if (state == 2 || state == 4 || state == 32) {
            serviceName = serviceName.append(new String[]{ConstantsHelper.bundleState((int)state)});
        }
        return serviceName;
    }

    void setServiceMode(ServiceName serviceName, ServiceController.Mode mode) {
        ServiceController controller = this.serviceContainer.getService(serviceName);
        if (controller == null) {
            FrameworkLogger.LOGGER.debugf("Cannot set mode %s on non-existing service: %s", mode, serviceName);
        } else {
            this.setServiceMode(controller, mode);
        }
    }

    void setServiceMode(ServiceController<?> controller, ServiceController.Mode mode) {
        block2: {
            try {
                FrameworkLogger.LOGGER.tracef("Set mode %s on service: %s", mode, controller.getName());
                controller.setMode(mode);
            }
            catch (IllegalArgumentException rte) {
                if (rte.getMessage().equals("Container is shutting down")) break block2;
                throw rte;
            }
        }
    }

    void fireFrameworkError(Bundle bundle2, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getFrameworkState().getFrameworkEventsPlugin();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundle2, 2, t);
        } else if (bundle2 != null) {
            plugin.fireFrameworkEvent(bundle2, 2, new BundleException("Error " + context + " bundle: " + bundle2, t));
        } else {
            SystemBundleState systemBundle = (SystemBundleState)((Object)this.injectedSystemBundle.getValue());
            plugin.fireFrameworkEvent((Bundle)systemBundle, 2, new BundleException("Error " + context, t));
        }
    }

    void fireFrameworkWarning(AbstractBundleState bundleState, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getFrameworkState().getFrameworkEventsPlugin();
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent((Bundle)bundleState, 16, t);
        } else if (bundleState != null) {
            plugin.fireFrameworkEvent((Bundle)bundleState, 16, new BundleException("Error " + context + " bundle: " + (Object)((Object)bundleState), t));
        } else {
            SystemBundleState systemBundle = (SystemBundleState)((Object)this.injectedSystemBundle.getValue());
            plugin.fireFrameworkEvent((Bundle)systemBundle, 16, new BundleException("Error " + context, t));
        }
    }

    boolean hasStopped() {
        return this.shutdownContainer.isShutdownInitiated() || this.managerStopped.get();
    }

    void assertNotStopped() {
        if (this.hasStopped()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkAlreadyStopped();
        }
    }

    void shutdownManager(boolean stopForUpdate) {
        int state = this.getManagerState();
        if (state != 8 && state != 32) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("Stop framework", new Object[0]);
        this.stoppedEvent = stopForUpdate ? 128 : 64;
        this.getSystemBundle().changeState(16);
        this.setManagerState(16);
        FrameworkCoreServices coreServices = this.getFrameworkState().getCoreServices();
        StartLevelPlugin startLevel = coreServices.getStartLevelPlugin();
        if (startLevel != null) {
            startLevel.decreaseStartLevel(0);
        } else {
            for (XBundle bundle2 : this.getBundles()) {
                if (bundle2.getBundleId() == 0L) continue;
                try {
                    bundle2.stop(1);
                }
                catch (Exception ex) {
                    this.fireFrameworkError((Bundle)bundle2, "stopping bundle", ex);
                }
            }
        }
        this.cachedSystemBundle = this.getSystemBundle();
        this.shutdownContainer.shutdown();
        this.setManagerState(4);
    }

    FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        SystemBundleState systemBundle = this.getSystemBundle();
        SystemBundleState eventSource = systemBundle != null ? systemBundle : this.cachedSystemBundle;
        FrameworkEvent frameworkEvent = null;
        this.shutdownContainer.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        if (eventSource != null) {
            int eventType = this.shutdownContainer.isShutdownComplete() ? this.stoppedEvent : 512;
            frameworkEvent = new FrameworkEvent(eventType, (Bundle)eventSource, null);
        }
        return frameworkEvent;
    }

    static String getOSVersionInOSGiFormat() {
        int i;
        StringBuilder osgiVersion = new StringBuilder();
        String sysVersion = SecurityActions.getSystemProperty("os.version", null);
        String[] elements = sysVersion.split("\\.");
        for (i = 0; i < 3 && i < elements.length; ++i) {
            try {
                Integer.parseInt(elements[i]);
                if (i > 0) {
                    osgiVersion.append('.');
                }
                osgiVersion.append(elements[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        if (i == 3 && elements.length > 3) {
            osgiVersion.append('.');
            osgiVersion.append(elements[3]);
        }
        return osgiVersion.toString();
    }

    static {
        OSGi_FRAMEWORK_LANGUAGE = Locale.getDefault().getLanguage();
        OSGi_FRAMEWORK_VENDOR = "jboss.org";
        OSGi_FRAMEWORK_VERSION = "1.5";
        implementationVersion = BundleManagerPlugin.class.getPackage().getImplementationVersion();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<String> execEnvironments = new ArrayList<String>();
                if (Java.isCompatible(2)) {
                    execEnvironments.add("OSGi/Minimum-1.1");
                    execEnvironments.add("J2SE-1.1");
                }
                if (Java.isCompatible(3)) {
                    execEnvironments.add("OSGi/Minimum-1.2");
                    execEnvironments.add("J2SE-1.2");
                }
                if (Java.isCompatible(4)) {
                    execEnvironments.add("J2SE-1.3");
                }
                if (Java.isCompatible(5)) {
                    execEnvironments.add("J2SE-1.4");
                }
                if (Java.isCompatible(6)) {
                    execEnvironments.add("J2SE-1.5");
                }
                if (Java.isCompatible(7)) {
                    execEnvironments.add("JavaSE-1.6");
                }
                String envlist = ((Object)execEnvironments).toString();
                envlist = envlist.substring(1, envlist.length() - 1);
                OSGi_FRAMEWORK_EXECUTIONENVIRONMENT = envlist;
                OSGi_FRAMEWORK_OS_NAME = SecurityActions.getSystemProperty("os.name", null);
                OSGi_FRAMEWORK_OS_VERSION = BundleManagerPlugin.getOSVersionInOSGiFormat();
                OSGi_FRAMEWORK_PROCESSOR = SecurityActions.getSystemProperty("os.arch", null);
                SecurityActions.setSystemProperty("org.osgi.vendor.framework", "org.jboss.osgi.framework");
                return null;
            }
        });
    }

    static class ShutdownContainer {
        private final ServiceContainer serviceContainer;
        private final AtomicBoolean shutdownInitiated;
        private final boolean allowContainerShutdown;

        ShutdownContainer(ServiceContainer serviceContainer, boolean allowContainerShutdown) {
            this.serviceContainer = serviceContainer;
            this.allowContainerShutdown = allowContainerShutdown;
            this.shutdownInitiated = new AtomicBoolean(false);
        }

        ServiceController<?> getRequiredService(ServiceName serviceName) {
            return this.serviceContainer.getRequiredService(serviceName);
        }

        boolean isShutdownInitiated() {
            return this.shutdownInitiated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            if (this.allowContainerShutdown) {
                this.serviceContainer.shutdown();
                AtomicBoolean atomicBoolean = this.shutdownInitiated;
                synchronized (atomicBoolean) {
                    this.shutdownInitiated.set(true);
                    FrameworkLogger.LOGGER.debugf("shutdownInitiated.notifyAll", new Object[0]);
                    this.shutdownInitiated.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            FrameworkLogger.LOGGER.debugf("awaitTermination: %dms", unit.toMillis(timeout));
            AtomicBoolean atomicBoolean = this.shutdownInitiated;
            synchronized (atomicBoolean) {
                if (!this.shutdownInitiated.get()) {
                    FrameworkLogger.LOGGER.debugf("shutdownInitiated.wait", new Object[0]);
                    this.shutdownInitiated.wait(2000L);
                }
            }
            this.serviceContainer.awaitTermination(timeout == 0L ? Long.MAX_VALUE : timeout, unit);
        }

        boolean isShutdownComplete() {
            return this.serviceContainer.isShutdownComplete();
        }
    }
}

