/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class BundleProtocolHandler
extends AbstractURLStreamHandlerService {
    public static final String PROTOCOL_NAME = "bundle";
    private final BundleManagerPlugin bundleManager;

    BundleProtocolHandler(BundleManagerPlugin bundleManager) {
        this.bundleManager = bundleManager;
    }

    public URLConnection openConnection(URL url) throws IOException {
        FrameworkLogger.LOGGER.tracef("openConnection: %s", url);
        RevisionContent revContent = RevisionContent.findRevisionContent(this.bundleManager, url.getHost());
        if (revContent == null) {
            throw FrameworkMessages.MESSAGES.cannotObtainRevisionContent(url);
        }
        URL entry = revContent.getEntry(url.getPath());
        if (entry == null) {
            throw FrameworkMessages.MESSAGES.cannotObtainContent(url);
        }
        return entry.openConnection();
    }
}

