/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

final class BundleStoragePlugin
extends AbstractIntegrationService<BundleStoragePlugin> {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final Map<String, InternalStorageState> storageStates = new HashMap<String, InternalStorageState>();
    private boolean firstInit;
    private File storageArea;

    BundleStoragePlugin(boolean firstInit) {
        super(InternalServices.BUNDLE_STORAGE_PLUGIN);
        this.firstInit = firstInit;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<BundleStoragePlugin> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        try {
            File[] storageDirs;
            BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
            String storageClean = (String)bundleManager.getProperty("org.osgi.framework.storage.clean");
            if (this.firstInit && "onFirstInit".equals(storageClean)) {
                File storage = this.getStorageArea();
                FrameworkLogger.LOGGER.debugf("Deleting storage: %s", storage.getAbsolutePath());
                this.deleteRecursive(storage);
            }
            if ((storageDirs = this.getStorageArea().listFiles()) != null) {
                for (File storageDir : storageDirs) {
                    InternalStorageState storageState = InternalStorageState.createStorageState(storageDir);
                    if (storageState.getBundleId() == 0L) continue;
                    this.storageStates.put(storageState.getLocation(), storageState);
                }
            }
        }
        catch (IOException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    public BundleStoragePlugin getValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalStorageState createStorageState(long bundleId, String location, int startlevel, VirtualFile rootFile) throws IOException {
        assert (location != null) : "Null location";
        File bundleDir = this.getStorageDir(bundleId);
        Properties props = InternalStorageState.loadProperties(bundleDir);
        String previousRev = props.getProperty("BundleRev");
        int revision = bundleId != 0L && previousRev != null ? Integer.parseInt(previousRev) + 1 : 0;
        props.put("Location", location);
        props.put("BundleId", new Long(bundleId).toString());
        props.put("BundleRev", new Integer(revision).toString());
        props.put("StartLevel", new Integer(startlevel).toString());
        props.put("LastModified", new Long(System.currentTimeMillis()).toString());
        InternalStorageState storageState = InternalStorageState.createStorageState(bundleDir, rootFile, props);
        Map<String, InternalStorageState> map = this.storageStates;
        synchronized (map) {
            if (storageState.getBundleId() != 0L) {
                this.storageStates.put(storageState.getLocation(), storageState);
            }
        }
        return storageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteStorageState(InternalStorageState storageState) {
        VFSUtils.safeClose((Closeable)storageState.getRootFile());
        this.deleteRecursive(storageState.getStorageDir());
        Map<String, InternalStorageState> map = this.storageStates;
        synchronized (map) {
            this.storageStates.remove(storageState.getLocation());
        }
    }

    Set<InternalStorageState> getBundleStorageStates() {
        return Collections.unmodifiableSet(new HashSet<InternalStorageState>(this.storageStates.values()));
    }

    InternalStorageState getStorageState(String location) {
        return location != null ? this.storageStates.get(location) : null;
    }

    File getStorageDir(long bundleId) {
        File bundleDir = new File(this.getStorageArea() + "/bundle-" + bundleId);
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        String filePath = bundleDir.getAbsolutePath();
        try {
            filePath = bundleDir.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    File getStorageArea() {
        if (this.storageArea == null) {
            BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
            String dirName = (String)bundleManager.getProperty("org.osgi.framework.storage");
            if (dirName == null) {
                try {
                    File storageDir = new File("./osgi-store");
                    dirName = storageDir.getCanonicalPath();
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.illegalStateCannotCreateStorageArea(ex);
                }
            }
            this.storageArea = new File(dirName).getAbsoluteFile();
        }
        return this.storageArea;
    }

    File getDataFile(long bundleId, String filename) {
        File bundleDir = this.getStorageDir(bundleId);
        File dataFile = new File(bundleDir.getAbsolutePath() + File.separator + filename);
        dataFile.getParentFile().mkdirs();
        String filePath = dataFile.getAbsolutePath();
        try {
            filePath = dataFile.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new File(filePath);
    }

    private void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                this.deleteRecursive(aux);
            }
        }
        file.delete();
    }

    static class InternalStorageState
    extends StorageState {
        private static InternalStorageState createStorageState(File storageDir) throws IOException {
            VirtualFile rootFile = null;
            Properties props = InternalStorageState.loadProperties(storageDir);
            String vfsLocation = props.getProperty("BundleFile");
            if (vfsLocation != null) {
                File revFile = new File(storageDir + "/" + vfsLocation);
                rootFile = AbstractVFS.toVirtualFile((URI)revFile.toURI());
            }
            InternalStorageState storageState = new InternalStorageState(storageDir, rootFile, props);
            FrameworkLogger.LOGGER.debugf("Created storage state: %s", storageState);
            return storageState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static InternalStorageState createStorageState(File storageDir, VirtualFile rootFile, Properties props) throws IOException {
            InternalStorageState storageState = new InternalStorageState(storageDir, rootFile, props);
            if (rootFile != null) {
                String bundleId = props.getProperty("BundleId");
                String revision = props.getProperty("BundleRev");
                File revFile = new File(storageDir + "/bundle-" + bundleId + "-rev-" + revision + ".jar");
                FileOutputStream output = new FileOutputStream(revFile);
                storageDir.mkdirs();
                InputStream input = rootFile.openStream();
                try {
                    VFSUtils.copyStream((InputStream)input, (OutputStream)output);
                }
                finally {
                    input.close();
                    output.close();
                }
                props.put("BundleFile", revFile.getName());
            }
            storageState.writeProperties();
            return storageState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Properties loadProperties(File storageDir) throws FileNotFoundException, IOException {
            Properties props = new Properties();
            File propsFile = new File(storageDir + "/" + "bundle-persistent.properties");
            if (propsFile.exists()) {
                FileInputStream input = new FileInputStream(propsFile);
                try {
                    props.load(input);
                }
                finally {
                    VFSUtils.safeClose((Closeable)input);
                }
            }
            return props;
        }

        private InternalStorageState(File storageDir, VirtualFile rootFile, Properties props) {
            super(storageDir, rootFile, props);
        }

        void updateLastModified() {
            this.getProperties().setProperty("LastModified", new Long(System.currentTimeMillis()).toString());
            this.writeProperties();
        }

        void setPersistentlyStarted(boolean started) {
            this.getProperties().setProperty("PersistentlyStarted", new Boolean(started).toString());
            this.writeProperties();
        }

        void setBundleActivationPolicyUsed(boolean usePolicy) {
            this.getProperties().setProperty("ActivationPolicyUsed", new Boolean(usePolicy).toString());
            this.writeProperties();
        }

        void setStartLevel(int level) {
            this.getProperties().setProperty("StartLevel", new Integer(level).toString());
            this.writeProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeProperties() {
            try {
                File propsFile = new File(this.getStorageDir() + "/" + "bundle-persistent.properties");
                FileOutputStream output = new FileOutputStream(propsFile);
                try {
                    this.getProperties().store(output, "Persistent Bundle Properties");
                }
                finally {
                    VFSUtils.safeClose((Closeable)output);
                }
            }
            catch (IOException ex) {
                FrameworkLogger.LOGGER.errorCannotWritePersistentStorage(ex, this.getStorageDir());
            }
        }
    }
}

