/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.HashSet;
import java.util.List;
import org.jboss.osgi.framework.internal.BundleValidator;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class BundleValidatorR4
implements BundleValidator {
    BundleValidatorR4() {
    }

    @Override
    public void validateBundle(UserBundleState userBundle, OSGiMetaData osgiMetaData) throws BundleException {
        List dynamicImports;
        List exportPackages;
        String packageName;
        String symbolicName = osgiMetaData.getBundleSymbolicName();
        if (symbolicName == null) {
            throw FrameworkMessages.MESSAGES.missingBundleSymbolicName((Bundle)userBundle);
        }
        int manifestVersion = osgiMetaData.getBundleManifestVersion();
        if (manifestVersion > 2) {
            throw FrameworkMessages.MESSAGES.unsupportedBundleManifestVersion(manifestVersion, (Bundle)userBundle);
        }
        List importPackages = osgiMetaData.getImportPackages();
        if (importPackages != null) {
            HashSet<String> packages = new HashSet<String>();
            for (PackageAttribute packageAttribute : importPackages) {
                packageName = packageAttribute.getAttribute();
                if (packages.contains(packageName)) {
                    throw FrameworkMessages.MESSAGES.duplicatePackageImport(packageName, (Bundle)userBundle);
                }
                packages.add(packageName);
                if (packageName.startsWith("java.")) {
                    throw FrameworkMessages.MESSAGES.notAllowdToImportJavaPackage((Bundle)userBundle);
                }
                String version = (String)packageAttribute.getAttributeValue("version", String.class);
                String specificationVersion = (String)packageAttribute.getAttributeValue("specification-version", String.class);
                if (version == null || specificationVersion == null || version.equals(specificationVersion)) continue;
                throw FrameworkMessages.MESSAGES.packageVersionAndSpecificationVersionMissmatch(packageName, (Bundle)userBundle);
            }
        }
        if ((exportPackages = osgiMetaData.getExportPackages()) != null) {
            for (PackageAttribute packageAttr : exportPackages) {
                packageName = packageAttr.getAttribute();
                if (packageName.startsWith("java.")) {
                    throw FrameworkMessages.MESSAGES.notAllowdToExportJavaPackage((Bundle)userBundle);
                }
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr != null && specificationAttr != null && !versionAttr.equals(specificationAttr)) {
                    throw FrameworkMessages.MESSAGES.packageVersionAndSpecificationVersionMissmatch(packageName, (Bundle)userBundle);
                }
                String symbolicNameAttr = (String)packageAttr.getAttributeValue("bundle-symbolic-name", String.class);
                if (symbolicNameAttr != null) {
                    throw FrameworkMessages.MESSAGES.packageCannotSpecifyBundleSymbolicName(packageName, (Bundle)userBundle);
                }
                String bundleVersionAttr = (String)packageAttr.getAttributeValue("bundle-version", String.class);
                if (bundleVersionAttr == null) continue;
                throw FrameworkMessages.MESSAGES.packageCannotSpecifyBundleVersion(packageName, (Bundle)userBundle);
            }
        }
        if ((dynamicImports = osgiMetaData.getDynamicImports()) != null) {
            for (PackageAttribute packageAttr : dynamicImports) {
                String packageName2 = packageAttr.getAttribute();
                String versionAttr = (String)packageAttr.getAttributeValue("version", String.class);
                String specificationAttr = (String)packageAttr.getAttributeValue("specification-version", String.class);
                if (versionAttr == null || specificationAttr == null || versionAttr.equals(specificationAttr)) continue;
                throw FrameworkMessages.MESSAGES.packageVersionAndSpecificationVersionMissmatch(packageName2, (Bundle)userBundle);
            }
        }
        for (XBundle bundle2 : userBundle.getBundleManager().getBundles()) {
            if (!userBundle.getSymbolicName().equals(bundle2.getSymbolicName()) || !userBundle.getVersion().equals((Object)bundle2.getVersion())) continue;
            throw FrameworkMessages.MESSAGES.nameAndVersionAlreadyInstalled((Bundle)userBundle);
        }
        if (userBundle.isFragment()) {
            ParameterizedAttribute hostAttr = osgiMetaData.getFragmentHost();
            String fragmentHost = hostAttr.getAttribute();
            String extension = (String)hostAttr.getDirectiveValue("extension", String.class);
            if (extension != null) {
                if (!"system.bundle".equals(fragmentHost)) {
                    throw FrameworkMessages.MESSAGES.invalidFragmentHostForExtensionFragment((Bundle)userBundle);
                }
                if ("bootclasspath".equals(extension)) {
                    throw FrameworkMessages.MESSAGES.unsupportedBootClasspathExtension();
                }
                if ("framework".equals(extension)) {
                    throw FrameworkMessages.MESSAGES.unsupportedFrameworkExtension();
                }
            }
        }
    }
}

