/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.BundleLock;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

class DefaultBundleLifecycleHandler
implements BundleLifecyclePlugin.DefaultHandler {
    static DefaultBundleLifecycleHandler INSTANCE = new DefaultBundleLifecycleHandler();

    private DefaultBundleLifecycleHandler() {
    }

    @Override
    public void install(BundleManager bundleManager, Deployment dep) throws BundleException {
        bundleManager.installBundle(dep, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(XBundle bundle2, int options) throws BundleException {
        HostBundleState hostState = HostBundleState.assertBundleState((Bundle)bundle2);
        hostState.aquireBundleLock(BundleLock.LockMethod.START);
        try {
            try {
                hostState.changeState(8);
            }
            catch (LifecycleInterceptorException ex) {
                throw FrameworkMessages.MESSAGES.cannotTransitionToStarting(ex, (Bundle)bundle2);
            }
            String className = hostState.getOSGiMetaData().getBundleActivator();
            if (className != null) {
                try {
                    hostState.bundleActivator = (BundleActivator)hostState.getDeployment().getAttachment(BundleActivator.class);
                    if (hostState.bundleActivator == null) {
                        Object result = hostState.loadClass(className).newInstance();
                        if (result instanceof BundleActivator) {
                            hostState.bundleActivator = (BundleActivator)result;
                        } else {
                            throw FrameworkMessages.MESSAGES.invalidBundleActivator(className);
                        }
                    }
                    if (hostState.bundleActivator != null) {
                        hostState.bundleActivator.start(hostState.getBundleContext());
                    }
                }
                catch (Throwable th) {
                    hostState.changeState(16);
                    this.removeServicesAndListeners(hostState);
                    hostState.destroyBundleContext();
                    hostState.changeState(4);
                    if (th instanceof BundleException) {
                        throw (BundleException)th;
                    }
                    throw FrameworkMessages.MESSAGES.cannotStartBundle(th, (Bundle)bundle2);
                }
            }
            if (hostState.getState() == 1) {
                throw FrameworkMessages.MESSAGES.uninstalledDuringActivatorStart((Bundle)bundle2);
            }
            hostState.changeState(32);
            hostState.getBundleManager().setServiceMode(hostState.getServiceName(32), ServiceController.Mode.ACTIVE);
            FrameworkLogger.LOGGER.infoBundleStarted((Bundle)bundle2);
        }
        finally {
            hostState.releaseBundleLock(BundleLock.LockMethod.START);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(XBundle bundle2, int options) throws BundleException {
        HostBundleState hostState = HostBundleState.assertBundleState((Bundle)bundle2);
        hostState.aquireBundleLock(BundleLock.LockMethod.STOP);
        try {
            int priorState;
            if (hostState.getState() == 1) {
                return;
            }
            if ((options & 1) == 0) {
                hostState.setPersistentlyStarted(false);
                hostState.setBundleActivationPolicyUsed(false);
            }
            if ((priorState = hostState.getState()) != 8 && priorState != 32) {
                return;
            }
            hostState.changeState(16);
            Throwable rethrow = null;
            if (priorState == 32 && hostState.bundleActivator != null) {
                try {
                    hostState.bundleActivator.stop(hostState.getBundleContext());
                }
                catch (Throwable t) {
                    rethrow = t;
                }
            }
            this.removeServicesAndListeners(hostState);
            if (hostState.getState() == 1) {
                throw FrameworkMessages.MESSAGES.uninstalledDuringActivatorStop((Bundle)bundle2);
            }
            hostState.destroyBundleContext();
            hostState.changeState(4, 4);
            hostState.getBundleManager().setServiceMode(hostState.getServiceName(32), ServiceController.Mode.NEVER);
            FrameworkLogger.LOGGER.infoBundleStopped((Bundle)bundle2);
            if (rethrow != null) {
                throw FrameworkMessages.MESSAGES.cannotStopBundle(rethrow, (Bundle)bundle2);
            }
        }
        finally {
            hostState.releaseBundleLock(BundleLock.LockMethod.STOP);
        }
    }

    @Override
    public void uninstall(XBundle bundle2) {
        BundleManager bundleManager = (BundleManager)bundle2.adapt(BundleManager.class);
        Deployment dep = (Deployment)bundle2.adapt(Deployment.class);
        bundleManager.uninstallBundle(dep);
    }

    private void removeServicesAndListeners(HostBundleState hostState) {
        for (ServiceState serviceState : hostState.getRegisteredServicesInternal()) {
            serviceState.unregisterInternal();
        }
        FrameworkEventsPlugin eventsPlugin = hostState.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.removeBundleListeners(hostState);
    }
}

