/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleReferenceClassLoader;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.FrameworkModulePlugin;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemPathsPlugin;
import org.osgi.framework.Bundle;

final class DefaultFrameworkModulePlugin
extends AbstractIntegrationService<FrameworkModulePlugin>
implements FrameworkModulePlugin {
    private static final ModuleIdentifier FRAMEWORK_MODULE_IDENTIFIER = ModuleIdentifier.create((String)"jbosgi.framework");
    private final InjectedValue<SystemPathsPlugin> injectedSystemPaths = new InjectedValue();
    private Module frameworkModule;

    DefaultFrameworkModulePlugin() {
        super(IntegrationServices.FRAMEWORK_MODULE_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkModulePlugin> builder) {
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PLUGIN, SystemPathsPlugin.class, this.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void stop(StopContext context) {
        this.frameworkModule = null;
    }

    public FrameworkModulePlugin getValue() {
        return this;
    }

    @Override
    public Module getFrameworkModule(Bundle bundle2) {
        if (this.frameworkModule == null) {
            SystemBundleState systemBundle = (SystemBundleState)bundle2;
            this.frameworkModule = this.createFrameworkModule(systemBundle);
        }
        return this.frameworkModule;
    }

    private Module createFrameworkModule(SystemBundleState systemBundle) {
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)FRAMEWORK_MODULE_IDENTIFIER);
        SystemPathsPlugin plugin = (SystemPathsPlugin)this.injectedSystemPaths.getValue();
        Set<String> bootPaths = plugin.getBootDelegationPaths();
        PathFilter bootFilter = plugin.getBootDelegationFilter();
        PathFilter acceptAll = PathFilters.acceptAll();
        specBuilder.addDependency(DependencySpec.createSystemDependencySpec((PathFilter)bootFilter, (PathFilter)acceptAll, bootPaths));
        final ClassLoader classLoader = BundleManagerPlugin.class.getClassLoader();
        LocalLoader localLoader = new LocalLoader(){

            public Class<?> loadClassLocal(String name, boolean resolve) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public Package loadPackageLocal(String name) {
                throw new UnsupportedOperationException();
            }

            public List<Resource> loadResourceLocal(String name) {
                return Collections.emptyList();
            }
        };
        Set<String> systemPaths = plugin.getSystemPaths();
        PathFilter systemFilter = plugin.getSystemFilter();
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)systemFilter, (PathFilter)PathFilters.acceptAll(), (LocalLoader)localLoader, systemPaths));
        specBuilder.setModuleClassLoaderFactory(new BundleReferenceClassLoader.Factory<SystemBundleState>(systemBundle));
        try {
            final ModuleSpec moduleSpec = specBuilder.create();
            ModuleLoader moduleLoader = new ModuleLoader(){

                protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                    return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                }

                public String toString() {
                    return ((Object)((Object)this)).getClass().getSimpleName();
                }
            };
            return moduleLoader.loadModule(specBuilder.getIdentifier());
        }
        catch (ModuleLoadException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateFrameworkModule(ex);
        }
    }
}

