/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ModuleLoaderPlugin;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;

final class DefaultModuleLoaderPlugin
extends ModuleLoader
implements ModuleLoaderPlugin,
IntegrationService<ModuleLoaderPlugin> {
    private Map<ModuleIdentifier, ModuleHolder> moduleSpecs = new ConcurrentHashMap<ModuleIdentifier, ModuleHolder>();
    private ServiceRegistry serviceRegistry;
    private ServiceTarget serviceTarget;

    DefaultModuleLoaderPlugin() {
    }

    @Override
    public ServiceName getServiceName() {
        return IntegrationServices.MODULE_LOADER_PLUGIN;
    }

    @Override
    public ServiceController<ModuleLoaderPlugin> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceBuilder builder = serviceTarget.addService(this.getServiceName(), (Service)this);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.addListener(listener);
        return builder.install();
    }

    public void start(StartContext context) throws StartException {
        FrameworkLogger.LOGGER.tracef("Starting: %s", context.getController().getName());
        this.serviceRegistry = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
    }

    public void stop(StopContext context) {
        FrameworkLogger.LOGGER.tracef("Stopping: %s", context.getController().getName());
    }

    public ModuleLoaderPlugin getValue() {
        return this;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this;
    }

    @Override
    public void addIntegrationDependencies(ModuleLoaderPlugin.ModuleSpecBuilderContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
            return moduleHolder != null ? moduleHolder.getModuleSpec() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = null;
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
            if (moduleHolder != null && (module = moduleHolder.getModule()) == null) {
                module = this.loadModuleLocal(identifier);
                moduleHolder.setModule(module);
            }
        }
        return module;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XBundleRevision brev) {
        XBundle bundle2 = brev.getBundle();
        String name = bundle2.getSymbolicName();
        String slot = bundle2.getVersion().toString();
        List allrevs = bundle2.getAllBundleRevisions();
        if (allrevs.size() > 1) {
            name = name + "-rev" + (allrevs.size() - 1);
        }
        return ModuleIdentifier.create((String)("jbosgi." + name), (String)slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModuleSpec(XBundleRevision brev, ModuleSpec moduleSpec) {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            FrameworkLogger.LOGGER.tracef("addModule: %s", moduleSpec.getModuleIdentifier());
            ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
            if (this.moduleSpecs.get(identifier) != null) {
                throw FrameworkMessages.MESSAGES.illegalStateModuleAlreadyExists(identifier);
            }
            ModuleHolder moduleHolder = new ModuleHolder(moduleSpec);
            this.moduleSpecs.put(identifier, moduleHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModule(XBundleRevision brev, Module module) {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            FrameworkLogger.LOGGER.tracef("addModule: %s", module.getIdentifier());
            ModuleIdentifier identifier = module.getIdentifier();
            if (this.moduleSpecs.get(identifier) != null) {
                throw FrameworkMessages.MESSAGES.illegalStateModuleAlreadyExists(identifier);
            }
            ModuleHolder moduleHolder = new ModuleHolder(module);
            this.moduleSpecs.put(identifier, moduleHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModule(XBundleRevision brev, ModuleIdentifier identifier) {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            FrameworkLogger.LOGGER.tracef("removeModule: %s", identifier);
            this.moduleSpecs.remove(identifier);
            ServiceController moduleService = this.serviceRegistry.getService(this.getModuleServiceName(identifier));
            if (moduleService != null) {
                moduleService.setMode(ServiceController.Mode.REMOVE);
            }
            try {
                Module module = this.loadModuleLocal(identifier);
                if (module != null) {
                    this.unloadModuleLocal(module);
                }
            }
            catch (ModuleLoadException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public ServiceName createModuleService(XBundleRevision resource, ModuleIdentifier identifier) {
        ServiceName moduleServiceName = this.getModuleServiceName(identifier);
        try {
            Module module = this.loadModule(identifier);
            ValueService service = new ValueService((Value)new ImmediateValue((Object)module));
            ServiceBuilder builder = this.serviceTarget.addService(moduleServiceName, (Service)service);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
        catch (ModuleLoadException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule(ex, identifier);
        }
        return moduleServiceName;
    }

    @Override
    public ServiceName getModuleServiceName(ModuleIdentifier identifier) {
        return InternalServices.MODULE_SERVICE.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public String toString() {
        return DefaultModuleLoaderPlugin.class.getSimpleName();
    }

    static class ModuleHolder {
        private ModuleSpec moduleSpec;
        private Module module;

        ModuleHolder(ModuleSpec moduleSpec) {
            assert (moduleSpec != null) : "Null moduleSpec";
            this.moduleSpec = moduleSpec;
        }

        ModuleHolder(Module module) {
            assert (module != null) : "Null module";
            this.module = module;
        }

        ModuleSpec getModuleSpec() {
            return this.moduleSpec;
        }

        Module getModule() {
            return this.module;
        }

        void setModule(Module module) {
            this.module = module;
        }
    }
}

