/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.framework.spi.StorageStatePlugin;
import org.osgi.framework.BundleException;

final class DefaultPersistentBundlesInstall
extends BootstrapBundlesInstall<Void> {
    private final InjectedValue<StorageStatePlugin> injectedStoragePlugin = new InjectedValue();
    private final InjectedValue<DeploymentFactoryPlugin> injectedDeploymentFactory = new InjectedValue();

    DefaultPersistentBundlesInstall() {
        super(IntegrationServices.PERSISTENT_BUNDLES);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<Void> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(IntegrationServices.STORAGE_STATE_PLUGIN, StorageStatePlugin.class, this.injectedStoragePlugin);
        builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, this.injectedDeploymentFactory);
        builder.addDependencies(new ServiceName[]{IntegrationServices.BOOTSTRAP_BUNDLES_COMPLETE});
    }

    public void start(StartContext context) throws StartException {
        DeploymentFactoryPlugin deploymentPlugin = (DeploymentFactoryPlugin)this.injectedDeploymentFactory.getValue();
        ServiceTarget serviceTarget = context.getChildTarget();
        StorageStatePlugin storageStatePlugin = (StorageStatePlugin)this.injectedStoragePlugin.getValue();
        HashSet<StorageState> storageStates = new HashSet<StorageState>(storageStatePlugin.getStorageStates());
        Iterator iterator = storageStates.iterator();
        while (iterator.hasNext()) {
            StorageState storageState = (StorageState)iterator.next();
            if (this.getBundleManager().getBundleById(storageState.getBundleId()) == null) continue;
            iterator.remove();
        }
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        for (StorageState storageState : storageStates) {
            try {
                Deployment dep = deploymentPlugin.createDeployment(storageState);
                deployments.add(dep);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, storageState.getLocation());
            }
        }
        this.installBootstrapBundles(serviceTarget, deployments);
    }
}

