/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.ExecutorServicePlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.service.startlevel.StartLevel;

final class DefaultStartLevelPlugin
extends ExecutorServicePlugin<StartLevelPlugin>
implements StartLevelPlugin {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<SystemBundleState> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private AtomicInteger initialBundleStartLevel = new AtomicInteger(1);
    private ServiceRegistration registration;
    private AtomicInteger startLevel = new AtomicInteger(0);

    DefaultStartLevelPlugin() {
        super(Services.START_LEVEL);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<StartLevelPlugin> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, this.injectedFrameworkEvents);
        builder.addDependency(InternalServices.SYSTEM_BUNDLE, SystemBundleState.class, this.injectedSystemBundle);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        BundleContext systemContext = ((SystemBundleState)((Object)this.injectedSystemBundle.getValue())).getBundleContext();
        this.registration = systemContext.registerService(StartLevel.class.getName(), (Object)this, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
    }

    public StartLevelPlugin getValue() {
        return this;
    }

    @Override
    ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi StartLevel Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public int getStartLevel() {
        return this.startLevel.get();
    }

    public synchronized void setStartLevel(final int level) {
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)this.injectedFrameworkEvents.getValue();
        final Bundle sysbundle = (Bundle)this.injectedSystemBundle.getValue();
        if (level > this.getStartLevel()) {
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoIncreasingStartLevel(DefaultStartLevelPlugin.this.getStartLevel(), level);
                    DefaultStartLevelPlugin.this.increaseStartLevel(level);
                    eventsPlugin.fireFrameworkEvent(sysbundle, 8, null);
                }
            });
        } else if (level < this.getStartLevel()) {
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoDecreasingStartLevel(DefaultStartLevelPlugin.this.getStartLevel(), level);
                    DefaultStartLevelPlugin.this.decreaseStartLevel(level);
                    eventsPlugin.fireFrameworkEvent(sysbundle, 8, null);
                }
            });
        }
    }

    public int getBundleStartLevel(Bundle bundle2) {
        return this.getBundleStartLevelState(bundle2).getLevel();
    }

    public void setBundleStartLevel(Bundle bundle2, int level) {
        if (bundle2.getBundleId() == 0L) {
            throw FrameworkMessages.MESSAGES.illegalArgumentStartLevelOnSystemBundles();
        }
        final XBundle hostBundle = (XBundle)bundle2;
        final FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)this.injectedFrameworkEvents.getValue();
        this.getBundleStartLevelState((Bundle)hostBundle).setLevel(level);
        if (level <= this.getStartLevel()) {
            if ((bundle2.getState() & 0x28) > 0) {
                return;
            }
            if (this.isBundlePersistentlyStarted(bundle2)) {
                FrameworkLogger.LOGGER.infoStartingBundleDueToStartLevel((Bundle)hostBundle);
                this.getExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int opts = 1;
                            if (DefaultStartLevelPlugin.this.isBundleActivationPolicyUsed((Bundle)hostBundle)) {
                                opts |= 2;
                            }
                            hostBundle.start(opts);
                        }
                        catch (BundleException e) {
                            eventsPlugin.fireFrameworkEvent((Bundle)hostBundle, 2, e);
                        }
                    }
                });
            }
        } else {
            if ((bundle2.getState() & 0x28) == 0) {
                return;
            }
            FrameworkLogger.LOGGER.infoStoppingBundleDueToStartLevel((Bundle)hostBundle);
            this.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        hostBundle.stop(1);
                    }
                    catch (BundleException e) {
                        eventsPlugin.fireFrameworkEvent((Bundle)hostBundle, 2, e);
                    }
                }
            });
        }
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel.get();
    }

    public void setInitialBundleStartLevel(int startlevel) {
        this.initialBundleStartLevel.set(startlevel);
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle2) {
        return this.getBundleStartLevelState(bundle2).isStarted();
    }

    @Override
    public void setBundlePersistentlyStarted(XBundle bundle2, boolean started) {
        this.getBundleStartLevelState((Bundle)bundle2).setStarted(started);
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle2) {
        boolean result = false;
        if (bundle2 instanceof AbstractBundleState) {
            AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
            BundleStoragePlugin.InternalStorageState storageState = bundleState.getStorageState();
            result = storageState.isBundleActivationPolicyUsed();
        }
        return result;
    }

    @Override
    public synchronized void increaseStartLevel(int level) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        ArrayList<XBundle> bundles = new ArrayList<XBundle>(bundleManager.getBundles());
        Comparator<XBundle> comparator = new Comparator<XBundle>(){

            @Override
            public int compare(XBundle b1, XBundle b2) {
                return (int)(b1.getBundleId() - b2.getBundleId());
            }
        };
        Collections.sort(bundles, comparator);
        while (this.startLevel.get() < level) {
            this.startLevel.incrementAndGet();
            FrameworkLogger.LOGGER.infoStartingBundlesForStartLevel(this.startLevel.get());
            for (XBundle bundle2 : bundles) {
                BundleStartLevelState state;
                if (bundle2.getBundleId() == 0L || bundle2.isFragment() || (state = this.getBundleStartLevelState((Bundle)bundle2)).getLevel() != this.startLevel.get() || !state.isStarted()) continue;
                try {
                    int opts = 1;
                    if (this.isBundleActivationPolicyUsed((Bundle)bundle2)) {
                        opts |= 2;
                    }
                    bundle2.start(opts);
                }
                catch (Throwable e) {
                    FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)this.injectedFrameworkEvents.getValue();
                    eventsPlugin.fireFrameworkEvent((Bundle)bundle2, 2, e);
                }
            }
        }
    }

    @Override
    public synchronized void decreaseStartLevel(int level) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        while (this.startLevel.get() > level) {
            FrameworkLogger.LOGGER.infoStoppingBundlesForStartLevel(level);
            ArrayList<XBundle> bundles = new ArrayList<XBundle>(bundleManager.getBundles());
            Comparator<XBundle> comparator = new Comparator<XBundle>(){

                @Override
                public int compare(XBundle b1, XBundle b2) {
                    return (int)(b1.getBundleId() - b2.getBundleId());
                }
            };
            Collections.sort(bundles, comparator);
            Collections.reverse(bundles);
            for (XBundle bundle2 : bundles) {
                BundleStartLevelState state;
                if (bundle2.getBundleId() == 0L || bundle2.isFragment() || (state = this.getBundleStartLevelState((Bundle)bundle2)).getLevel() != this.startLevel.get()) continue;
                try {
                    bundle2.stop(1);
                }
                catch (Throwable e) {
                    FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)this.injectedFrameworkEvents.getValue();
                    eventsPlugin.fireFrameworkEvent((Bundle)bundle2, 2, e);
                }
            }
            this.startLevel.decrementAndGet();
        }
    }

    private BundleStartLevelState getBundleStartLevelState(Bundle bundle2) {
        if (bundle2 instanceof Framework) {
            return new BundleStartLevelState(bundle2);
        }
        XBundle bundleState = (XBundle)bundle2;
        BundleStartLevelState state = (BundleStartLevelState)bundleState.getAttachment(BundleStartLevelState.class);
        if (state == null) {
            state = new BundleStartLevelState(bundle2);
            bundleState.addAttachment(BundleStartLevelState.class, (Object)state);
        }
        return state;
    }

    class BundleStartLevelState {
        final Bundle bundle;
        boolean started;
        int level;

        public BundleStartLevelState(Bundle bundle2) {
            this.bundle = bundle2;
            if (bundle2.getBundleId() > 0L) {
                XBundle bundleState = (XBundle)bundle2;
                int n = this.level = !bundleState.isFragment() ? DefaultStartLevelPlugin.this.getInitialBundleStartLevel() : 0;
                if (bundleState instanceof HostBundleState) {
                    XBundleRevision brev = bundleState.getBundleRevision();
                    BundleStoragePlugin.InternalStorageState storageState = ((BundleStateRevision)brev).getStorageState();
                    this.level = storageState.getStartLevel();
                }
            }
        }

        int getLevel() {
            return this.level;
        }

        void setLevel(int level) {
            this.level = level;
            if (this.bundle instanceof HostBundleState) {
                XBundleRevision brev = ((XBundle)this.bundle).getBundleRevision();
                BundleStoragePlugin.InternalStorageState storageState = ((BundleStateRevision)brev).getStorageState();
                storageState.setStartLevel(level);
            }
        }

        boolean isStarted() {
            return this.started;
        }

        void setStarted(boolean started) {
            this.started = started;
            if (this.bundle instanceof HostBundleState) {
                XBundleRevision brev = ((XBundle)this.bundle).getBundleRevision();
                BundleStoragePlugin.InternalStorageState storageState = ((BundleStateRevision)brev).getStorageState();
                storageState.setPersistentlyStarted(started);
            }
        }
    }
}

