/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.framework.spi.StorageStatePlugin;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.vfs.VirtualFile;

final class DefaultStorageStatePlugin
extends AbstractIntegrationService<StorageStatePlugin>
implements StorageStatePlugin {
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<DeploymentFactoryPlugin> injectedDeploymentFactory = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();

    DefaultStorageStatePlugin() {
        super(IntegrationServices.STORAGE_STATE_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<StorageStatePlugin> builder) {
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, this.injectedBundleStorage);
        builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, this.injectedDeploymentFactory);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public StorageStatePlugin getValue() {
        return this;
    }

    @Override
    public Set<StorageState> getStorageStates() {
        BundleStoragePlugin bundleStorage = (BundleStoragePlugin)this.injectedBundleStorage.getValue();
        Set<BundleStoragePlugin.InternalStorageState> storageStates = bundleStorage.getBundleStorageStates();
        return Collections.unmodifiableSet(new HashSet<BundleStoragePlugin.InternalStorageState>(storageStates));
    }

    @Override
    public StorageState getStorageState(String location) {
        BundleStoragePlugin bundleStorage = (BundleStoragePlugin)this.injectedBundleStorage.getValue();
        return bundleStorage.getStorageState(location);
    }

    @Override
    public StorageState createStorageState(String location, int startlevel, VirtualFile rootFile) throws IOException {
        BundleStoragePlugin bundleStorage = (BundleStoragePlugin)this.injectedBundleStorage.getValue();
        Long bundleId = ((XEnvironment)this.injectedEnvironment.getValue()).nextResourceIdentifier(null, location);
        return bundleStorage.createStorageState(bundleId, location, startlevel, rootFile);
    }
}

