/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.util.Properties;
import java.util.jar.Manifest;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class DeploymentFactoryPlugin
extends AbstractIntegrationService<DeploymentFactoryPlugin> {
    DeploymentFactoryPlugin() {
        super(InternalServices.DEPLOYMENT_FACTORY_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<DeploymentFactoryPlugin> builder) {
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public DeploymentFactoryPlugin getValue() {
        return this;
    }

    Deployment createDeployment(StorageState storageState) throws BundleException {
        assert (storageState != null) : "Null storageState";
        String location = storageState.getLocation();
        VirtualFile rootFile = storageState.getRootFile();
        Deployment dep = this.createDeployment(location, rootFile);
        dep.setAutoStart(storageState.isPersistentlyStarted());
        dep.setStartLevel(Integer.valueOf(storageState.getStartLevel()));
        dep.addAttachment(StorageState.class, (Object)storageState);
        return dep;
    }

    Deployment createDeployment(String location, VirtualFile rootFile) throws BundleException {
        BundleException cause = null;
        try {
            BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)rootFile, (String)location);
            Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
            OSGiMetaData metadata = info.getOSGiMetadata();
            dep.addAttachment(BundleInfo.class, (Object)info);
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
            return dep;
        }
        catch (NumberFormatException nfe) {
            throw FrameworkMessages.MESSAGES.invalidNumberFormat(nfe, nfe.getMessage());
        }
        catch (BundleException ex) {
            cause = ex;
            OSGiMetaData metadata = this.getXServiceMetaData(rootFile);
            if (metadata != null) {
                String symbolicName = metadata.getBundleSymbolicName();
                Version version = metadata.getBundleVersion();
                Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, (String)symbolicName, (Version)version);
                dep.addAttachment(OSGiMetaData.class, (Object)metadata);
                return dep;
            }
            Manifest manifest = null;
            try {
                manifest = VFSUtils.getManifest((VirtualFile)rootFile);
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (manifest != null && manifest.getMainAttributes().keySet().size() < 2) {
                Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, null, (Version)Version.emptyVersion);
                metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
                dep.addAttachment(OSGiMetaData.class, (Object)metadata);
                return dep;
            }
            throw cause != null ? cause : new BundleException("Cannot create deployment from: " + rootFile);
        }
    }

    OSGiMetaData createOSGiMetaData(Deployment deployment) throws BundleException {
        VirtualFile rootFile;
        OSGiMetaData metadata = (OSGiMetaData)deployment.getAttachment(OSGiMetaData.class);
        if (metadata != null) {
            return metadata;
        }
        BundleInfo info = (BundleInfo)deployment.getAttachment(BundleInfo.class);
        if (info != null) {
            metadata = info.getOSGiMetadata();
        }
        if (metadata == null) {
            rootFile = deployment.getRoot();
            String location = deployment.getLocation();
            try {
                info = BundleInfo.createBundleInfo((VirtualFile)rootFile, (String)location);
                metadata = info.getOSGiMetadata();
            }
            catch (BundleException ex) {
                // empty catch block
            }
        }
        if (metadata == null) {
            rootFile = deployment.getRoot();
            metadata = this.getXServiceMetaData(rootFile);
        }
        if (metadata == null) {
            throw FrameworkMessages.MESSAGES.invalidDeployment(deployment);
        }
        deployment.addAttachment(OSGiMetaData.class, (Object)metadata);
        return metadata;
    }

    private OSGiMetaData getXServiceMetaData(VirtualFile rootFile) {
        try {
            VirtualFile child = rootFile.getChild("META-INF/jbosgi-xservice.properties");
            if (child != null) {
                Properties props = new Properties();
                props.load(child.openStream());
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((Properties)props);
                return metadata;
            }
            VirtualFile parentFile = rootFile.getParent();
            if (parentFile != null && (child = parentFile.getChild("jbosgi-xservice.properties")) != null) {
                Properties props = new Properties();
                props.load(child.openStream());
                OSGiMetaData metadata = OSGiMetaDataBuilder.load((Properties)props);
                return metadata;
            }
        }
        catch (IOException ex) {
            FrameworkLogger.LOGGER.warnCannotProcessMetadataProperties(ex, rootFile);
        }
        return null;
    }
}

