/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.LockManagerPlugin;
import org.jboss.osgi.framework.spi.AbstractBundleWiring;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractEnvironment;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

final class EnvironmentPlugin
extends AbstractEnvironment
implements IntegrationService<XEnvironment> {
    private final InjectedValue<LockManagerPlugin> injectedLockManager = new InjectedValue();

    EnvironmentPlugin() {
    }

    @Override
    public ServiceName getServiceName() {
        return Services.ENVIRONMENT;
    }

    @Override
    public ServiceController<XEnvironment> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceBuilder builder = serviceTarget.addService(Services.ENVIRONMENT, (Service)this);
        builder.addDependency(InternalServices.LOCK_MANAGER_PLUGIN, LockManagerPlugin.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.addListener(listener);
        return builder.install();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public XEnvironment getValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installResources(XResource ... resources) {
        for (XResource res : resources) {
            if (!(res instanceof XBundleRevision)) {
                throw FrameworkMessages.MESSAGES.unsupportedResourceType(res);
            }
            XBundleRevision brev = (XBundleRevision)res;
            if (brev.getBundle() != null) continue;
            throw FrameworkMessages.MESSAGES.cannotObtainBundleFromResource(res);
        }
        this.aquireFrameworkLock();
        try {
            super.installResources(resources);
        }
        finally {
            this.releaseFrameworkLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void uninstallResources(XResource ... resources) {
        this.aquireFrameworkLock();
        try {
            super.uninstallResources(resources);
        }
        finally {
            this.releaseFrameworkLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshResources(XResource ... resources) {
        this.aquireFrameworkLock();
        try {
            super.refreshResources(resources);
        }
        finally {
            this.releaseFrameworkLock();
        }
    }

    public Wiring createWiring(XResource res, List<Wire> required, List<Wire> provided) {
        XBundleRevision brev = (XBundleRevision)res;
        return new AbstractBundleWiring(brev, required, provided);
    }

    private void aquireFrameworkLock() {
        try {
            LockManagerPlugin lockManager = (LockManagerPlugin)this.injectedLockManager.getValue();
            lockManager.aquireFrameworkLock();
        }
        catch (TimeoutException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void releaseFrameworkLock() {
        LockManagerPlugin lockManager = (LockManagerPlugin)this.injectedLockManager.getValue();
        lockManager.releaseFrameworkLock();
    }
}

