/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;

abstract class ExecutorServicePlugin<T>
extends AbstractIntegrationService<T> {
    private ExecutorService executorService;
    private boolean immediateExecution;

    ExecutorServicePlugin(ServiceName serviceName) {
        super(serviceName);
    }

    public void start(StartContext context) throws StartException {
        this.executorService = this.createExecutorService();
    }

    public void stop(StopContext context) {
        this.executorService.shutdown();
    }

    abstract ExecutorService createExecutorService();

    ExecutorService getExecutorService() {
        return !this.immediateExecution ? this.executorService : ImmediateExecutorService.INSTANCE;
    }

    public void enableImmediateExecution(boolean immediateExecution) {
        this.immediateExecution = immediateExecution;
    }

    private static class ImmediateExecutorService
    extends AbstractExecutorService {
        static ExecutorService INSTANCE = new ImmediateExecutorService();

        private ImmediateExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }
    }
}

