/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.URLResource;
import org.jboss.osgi.framework.spi.SystemPathsPlugin;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

final class FallbackLoader
implements LocalLoader {
    private final ReentrantLock fallbackLoaderLock = new ReentrantLock();
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final HostBundleState hostBundle;
    private final HostBundleRevision hostRev;
    private final ModuleIdentifier identifier;
    private final Set<String> importedPaths;
    private final FrameworkState frameworkState;
    private final BundleManagerPlugin bundleManager;
    private final ModuleManagerPlugin moduleManager;
    private static ThreadLocal<Map<String, AtomicInteger>> dynamicLoadAttempts;

    FallbackLoader(HostBundleRevision hostRev, ModuleIdentifier identifier, Set<String> importedPaths) {
        assert (hostRev != null) : "Null hostRev";
        assert (identifier != null) : "Null identifier";
        assert (importedPaths != null) : "Null importedPaths";
        this.identifier = identifier;
        this.importedPaths = importedPaths;
        this.hostRev = hostRev;
        this.hostBundle = hostRev.getBundleState();
        this.bundleManager = this.hostBundle.getBundleManager();
        this.frameworkState = this.hostBundle.getFrameworkState();
        this.moduleManager = this.frameworkState.getModuleManagerPlugin();
        hostRev.setFallbackLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setEnabled(boolean flag) {
        try {
            this.fallbackLoaderLock.lock();
            boolean bl = this.enabled.getAndSet(flag);
            return bl;
        }
        finally {
            this.fallbackLoaderLock.unlock();
        }
    }

    void lock() {
        this.fallbackLoaderLock.lock();
    }

    void unlock() {
        this.fallbackLoaderLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClassLocal(String className, boolean resolve) {
        try {
            this.fallbackLoaderLock.lock();
            List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(className);
            if (!this.enabled.get() || matchingPatterns.isEmpty()) {
                Class<?> clazz = null;
                return clazz;
            }
            String pathName = className.replace('.', '/') + ".class";
            Module module = this.findModuleDynamically(pathName, matchingPatterns);
            if (module == null) {
                Class<?> clazz = null;
                return clazz;
            }
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            try {
                Class clazz = moduleClassLoader.loadClass(className);
                return clazz;
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.tracef("Cannot load class [%s] from module: %s", className, module);
                Class<?> clazz = null;
                this.fallbackLoaderLock.unlock();
                return clazz;
            }
        }
        finally {
            this.fallbackLoaderLock.unlock();
        }
    }

    public Package loadPackageLocal(String name) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> loadResourceLocal(String resName) {
        try {
            this.fallbackLoaderLock.lock();
            if (resName.startsWith("/")) {
                resName = resName.substring(1);
            }
            List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(resName);
            if (!this.enabled.get() || matchingPatterns.isEmpty()) {
                List<Resource> list = Collections.emptyList();
                return list;
            }
            Module module = this.findModuleDynamically(resName, matchingPatterns);
            if (module == null) {
                List<Resource> list = Collections.emptyList();
                return list;
            }
            URL resURL = module.getExportedResource(resName);
            if (resURL == null) {
                FrameworkLogger.LOGGER.tracef("Cannot load resource [%s] from module: %s", resName, module);
                List<Resource> list = Collections.emptyList();
                return list;
            }
            List<Resource> list = Collections.singletonList(new URLResource(resURL));
            return list;
        }
        finally {
            this.fallbackLoaderLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module findModuleDynamically(String resName, List<XPackageRequirement> matchingPatterns) {
        int idx = resName.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        String path = resName.substring(0, idx);
        if (this.importedPaths.contains(path)) {
            return null;
        }
        if (dynamicLoadAttempts == null) {
            dynamicLoadAttempts = new ThreadLocal();
        }
        Map<String, AtomicInteger> mapping = dynamicLoadAttempts.get();
        boolean removeThreadLocalMapping = false;
        try {
            AtomicInteger recursiveDepth;
            if (mapping == null) {
                mapping = new HashMap<String, AtomicInteger>();
                dynamicLoadAttempts.set(mapping);
                removeThreadLocalMapping = true;
            }
            if ((recursiveDepth = mapping.get(resName)) == null) {
                recursiveDepth = new AtomicInteger();
                mapping.put(resName, recursiveDepth);
            }
            if (recursiveDepth.incrementAndGet() == 1) {
                Module module = this.findInResolvedModules(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module2 = module;
                    return module2;
                }
                module = this.findInUnresolvedModules(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module3 = module;
                    return module3;
                }
                module = this.findInFrameworkModule(resName, matchingPatterns);
                if (module != null && !module.getIdentifier().equals(this.identifier)) {
                    Module module4 = module;
                    return module4;
                }
            }
        }
        finally {
            if (removeThreadLocalMapping) {
                dynamicLoadAttempts.remove();
            } else {
                AtomicInteger recursiveDepth = mapping.get(resName);
                if (recursiveDepth.decrementAndGet() == 0) {
                    mapping.remove(resName);
                }
            }
        }
        return null;
    }

    private List<XPackageRequirement> findMatchingPatterns(String resName) {
        List<XPackageRequirement> dynamicRequirements = this.getDynamicPackageRequirements((BundleRevision)this.hostRev);
        String pathName = VFSUtils.getPathFromClassName((String)resName);
        List<XPackageCapability> packageCapabilities = this.getPackageCapabilities((BundleRevision)this.hostRev);
        for (XPackageCapability packageCap : packageCapabilities) {
            String packagePath = packageCap.getPackageName().replace('.', '/');
            if (!pathName.equals(packagePath)) continue;
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> foundMatch = new ArrayList<XPackageRequirement>();
        for (XPackageRequirement dynreq : dynamicRequirements) {
            String pattern = dynreq.getPackageName();
            if (pattern.equals("*")) {
                foundMatch.add(dynreq);
                continue;
            }
            String patternPath = this.getPatternPath(pattern);
            if (!pathName.startsWith(patternPath)) continue;
            foundMatch.add(dynreq);
        }
        if (!foundMatch.isEmpty()) {
            FrameworkLogger.LOGGER.tracef("Found match for path [%s] with Dynamic-ImportPackage pattern: %s", resName, foundMatch);
        } else {
            FrameworkLogger.LOGGER.tracef("Class [%s] does not match Dynamic-ImportPackage patterns", resName);
        }
        return foundMatch;
    }

    private Module findInResolvedModules(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in resolved modules ...", new Object[0]);
        Set<XBundle> resolved = this.bundleManager.getBundles(36);
        FrameworkLogger.LOGGER.tracef("Resolved modules: %d", resolved.size());
        if (FrameworkLogger.LOGGER.isTraceEnabled()) {
            for (XBundle bundle2 : resolved) {
                FrameworkLogger.LOGGER.tracef("   %s", bundle2);
            }
        }
        if (!resolved.isEmpty()) {
            for (XPackageRequirement pkgreq : matchingPatterns) {
                for (XBundle bundle3 : resolved) {
                    ModuleIdentifier identifier;
                    Module candidate;
                    XBundleRevision brev = bundle3.getBundleRevision();
                    if (bundle3.getBundleId() <= 0L || brev.isFragment() || !this.isValidCandidate(resName, pkgreq, brev, candidate = this.moduleManager.getModule(identifier = this.moduleManager.getModuleIdentifier(brev)))) continue;
                    return candidate;
                }
            }
        }
        return null;
    }

    private Module findInUnresolvedModules(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in unresolved modules ...", new Object[0]);
        Set<XBundle> unresolved = this.bundleManager.getBundles(2);
        FrameworkLogger.LOGGER.tracef("Unresolved modules: %d", unresolved.size());
        if (FrameworkLogger.LOGGER.isTraceEnabled()) {
            for (XBundle bundle2 : unresolved) {
                FrameworkLogger.LOGGER.tracef("   %s", bundle2);
            }
        }
        for (XBundle bundle2 : unresolved) {
            if (!(bundle2 instanceof AbstractBundleState)) {
                FrameworkLogger.LOGGER.tracef("Ignore invalid bundle type: %s", bundle2);
                continue;
            }
            FrameworkLogger.LOGGER.tracef("Attempt to resolve: %s", bundle2);
            AbstractBundleState.assertBundleState((Bundle)bundle2).ensureResolved(false);
        }
        return this.findInResolvedModules(resName, matchingPatterns);
    }

    private Module findInFrameworkModule(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in framework module ...", new Object[0]);
        int lastIndex = resName.lastIndexOf(47);
        String pathName = lastIndex > 0 ? resName.substring(0, lastIndex) : resName;
        Module candidate = this.moduleManager.getFrameworkModule();
        SystemPathsPlugin systemPaths = this.frameworkState.getSystemPathsPlugin();
        return systemPaths.getSystemPaths().contains(pathName) ? candidate : null;
    }

    private boolean isValidCandidate(String resName, XPackageRequirement pkgreq, XBundleRevision brev, Module candidate) {
        if (candidate == null) {
            return false;
        }
        ModuleIdentifier candidateId = candidate.getIdentifier();
        if (candidateId.equals(this.identifier)) {
            return false;
        }
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically [%s] in %s ...", resName, candidateId);
        URL resURL = candidate.getExportedResource(resName);
        if (resURL == null) {
            return false;
        }
        XPackageCapability candidateCap = this.getCandidateCapability((BundleRevision)brev, pkgreq);
        return candidateCap != null;
    }

    private XPackageCapability getCandidateCapability(BundleRevision brev, XPackageRequirement packageReq) {
        for (XPackageCapability packageCap : this.getPackageCapabilities(brev)) {
            if (!packageReq.matches((Capability)packageCap)) continue;
            FrameworkLogger.LOGGER.tracef("Matching package capability: %s", packageCap);
            return packageCap;
        }
        return null;
    }

    private String getPatternPath(String pattern) {
        String patternPath = pattern;
        if (pattern.endsWith(".*")) {
            patternPath = pattern.substring(0, pattern.length() - 2);
        }
        patternPath = patternPath.replace('.', '/');
        return patternPath;
    }

    private List<XPackageCapability> getPackageCapabilities(BundleRevision brev) {
        ArrayList<XPackageCapability> result = new ArrayList<XPackageCapability>();
        for (Capability aux : brev.getCapabilities("osgi.wiring.package")) {
            result.add((XPackageCapability)((XCapability)aux).adapt(XPackageCapability.class));
        }
        return result;
    }

    private List<XPackageRequirement> getDynamicPackageRequirements(BundleRevision brev) {
        ArrayList<XPackageRequirement> result = new ArrayList<XPackageRequirement>();
        for (Requirement aux : brev.getRequirements("osgi.wiring.package")) {
            XRequirement xreq = (XRequirement)aux;
            XPackageRequirement preq = (XPackageRequirement)xreq.adapt(XPackageRequirement.class);
            if (!preq.isDynamic()) continue;
            result.add(preq);
        }
        return result;
    }
}

