/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.resolver.ResolutionException;

public final class FrameworkActive
extends AbstractFrameworkService {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();

    FrameworkActive() {
        super(InternalServices.FRAMEWORK_STATE_ACTIVE);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkState> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_STATE_INIT, FrameworkState.class, this.injectedFramework);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            ResolverPlugin resolverPlugin = this.getValue().getResolverPlugin();
            SystemBundleRevision sysrev = this.getSystemBundle().getBundleRevision();
            resolverPlugin.resolveAndApply(Collections.singleton(sysrev), null);
            this.getSystemBundle().changeState(32);
            StartLevelPlugin startLevelPlugin = this.getValue().getCoreServices().getStartLevelPlugin();
            startLevelPlugin.increaseStartLevel(this.getBeginningStartLevel());
            BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
            bundleManager.injectedFrameworkActive.inject((Object)Boolean.TRUE);
            FrameworkEventsPlugin eventsPlugin = this.getValue().getFrameworkEventsPlugin();
            eventsPlugin.fireFrameworkEvent((Bundle)this.getSystemBundle(), 1, null);
            FrameworkLogger.LOGGER.infoFrameworkStarted();
        }
        catch (ResolutionException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        bundleManager.injectedFrameworkActive.uninject();
        super.stop(context);
    }

    public FrameworkState getValue() {
        return (FrameworkState)this.injectedFramework.getValue();
    }

    private int getBeginningStartLevel() {
        String levelSpec = (String)this.getBundleManager().getProperty("org.osgi.framework.startlevel.beginning");
        if (levelSpec != null) {
            try {
                return Integer.parseInt(levelSpec);
            }
            catch (NumberFormatException nfe) {
                FrameworkLogger.LOGGER.errorInvalidBeginningStartLevel(levelSpec);
            }
        }
        return 1;
    }

    static class FrameworkActivated
    extends AbstractIntegrationService<BundleContext> {
        private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
        private final ServiceController.Mode initialMode;

        FrameworkActivated(ServiceController.Mode initialMode) {
            super(Services.FRAMEWORK_ACTIVE);
            this.initialMode = initialMode;
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(Services.FRAMEWORK_INIT, BundleContext.class, this.injectedBundleContext);
            builder.addDependency(InternalServices.FRAMEWORK_STATE_ACTIVE);
            builder.setInitialMode(this.initialMode);
        }

        public BundleContext getValue() throws IllegalStateException {
            return (BundleContext)this.injectedBundleContext.getValue();
        }
    }
}

