/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.jboss.osgi.framework.spi.SystemServicesPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;

final class FrameworkCoreServices
extends AbstractIntegrationService<FrameworkCoreServices> {
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
    private final InjectedValue<BundleLifecyclePlugin> injectedBundleLifecycle = new InjectedValue();
    private final InjectedValue<LifecycleInterceptorPlugin> injectedLifecycleInterceptor = new InjectedValue();
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<StartLevelPlugin> injectedStartLevel = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<SystemServicesPlugin> injectedSystemServices = new InjectedValue();

    FrameworkCoreServices() {
        super(InternalServices.FRAMEWORK_CORE_SERVICES);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkCoreServices> builder) {
        builder.addDependency(IntegrationServices.BUNDLE_LIFECYCLE_PLUGIN, BundleLifecyclePlugin.class, this.injectedBundleLifecycle);
        builder.addDependency(InternalServices.FRAMEWORK_STATE_CREATE, FrameworkState.class, this.injectedFramework);
        builder.addDependency(InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN, LifecycleInterceptorPlugin.class, this.injectedLifecycleInterceptor);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, this.injectedPackageAdmin);
        builder.addDependency(Services.START_LEVEL, StartLevelPlugin.class, this.injectedStartLevel);
        builder.addDependency(InternalServices.SYSTEM_CONTEXT, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(IntegrationServices.SYSTEM_SERVICES_PLUGIN, SystemServicesPlugin.class, this.injectedSystemServices);
        builder.addDependencies(new ServiceName[]{InternalServices.URL_HANDLER_PLUGIN});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        SystemServicesPlugin systemServices = (SystemServicesPlugin)this.injectedSystemServices.getValue();
        systemServices.registerSystemServices(systemContext);
        this.getFrameworkState().injectedCoreServices.inject((Object)this);
    }

    public void stop(StopContext context) {
        this.getFrameworkState().injectedCoreServices.uninject();
    }

    public FrameworkCoreServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    BundleLifecyclePlugin getBundleLifecyclePlugin() {
        return (BundleLifecyclePlugin)this.injectedBundleLifecycle.getValue();
    }

    FrameworkState getFrameworkState() {
        return (FrameworkState)this.injectedFramework.getValue();
    }

    LifecycleInterceptorPlugin getLifecycleInterceptorPlugin() {
        return (LifecycleInterceptorPlugin)this.injectedLifecycleInterceptor.getValue();
    }

    PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.injectedPackageAdmin.getValue();
    }

    StartLevelPlugin getStartLevelPlugin() {
        return (StartLevelPlugin)this.injectedStartLevel.getValue();
    }
}

