/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ModuleLoaderPlugin;
import org.jboss.osgi.framework.spi.SystemPathsPlugin;
import org.jboss.osgi.resolver.XEnvironment;
import org.osgi.framework.BundleContext;

public final class FrameworkCreate
extends AbstractFrameworkService {
    private final FrameworkState frameworkState;

    FrameworkCreate(FrameworkState frameworkState) {
        super(InternalServices.FRAMEWORK_STATE_CREATE);
        this.frameworkState = frameworkState;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkState> builder) {
        builder.addDependency(InternalServices.DEPLOYMENT_FACTORY_PLUGIN, DeploymentFactoryPlugin.class, this.frameworkState.injectedDeploymentFactory);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, this.frameworkState.injectedBundleStorage);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, this.frameworkState.injectedFrameworkEvents);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, this.frameworkState.injectedModuleManager);
        builder.addDependency(IntegrationServices.MODULE_LOADER_PLUGIN, ModuleLoaderPlugin.class, this.frameworkState.injectedModuleLoader);
        builder.addDependency(InternalServices.NATIVE_CODE_PLUGIN, NativeCodePlugin.class, this.frameworkState.injectedNativeCode);
        builder.addDependency(InternalServices.SERVICE_MANAGER_PLUGIN, ServiceManagerPlugin.class, this.frameworkState.injectedServiceManager);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PLUGIN, SystemPathsPlugin.class, this.frameworkState.injectedSystemPaths);
        builder.addDependency(InternalServices.SYSTEM_BUNDLE, SystemBundleState.class, this.frameworkState.injectedSystemBundle);
        builder.addDependency(Services.RESOLVER, ResolverPlugin.class, this.frameworkState.injectedResolverPlugin);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.frameworkState.injectedEnvironment);
        builder.addDependency(IntegrationServices.STORAGE_STATE_PLUGIN);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        this.getBundleManager().injectedFramework.inject((Object)this.frameworkState);
    }

    @Override
    public void stop(StopContext context) {
        this.getBundleManager().injectedFramework.uninject();
    }

    public FrameworkState getValue() {
        return this.frameworkState;
    }

    static class FrameworkCreated
    extends AbstractIntegrationService<BundleContext> {
        final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();
        private final ServiceController.Mode initialMode;

        FrameworkCreated(ServiceController.Mode initialMode) {
            super(Services.FRAMEWORK_CREATE);
            this.initialMode = initialMode;
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(InternalServices.FRAMEWORK_STATE_CREATE, FrameworkState.class, this.injectedFramework);
            builder.setInitialMode(this.initialMode);
        }

        public BundleContext getValue() throws IllegalStateException {
            FrameworkState frameworkState = (FrameworkState)this.injectedFramework.getValue();
            SystemBundleState systemBundle = frameworkState.getSystemBundle();
            return systemBundle.getBundleContext();
        }
    }
}

