/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.osgi.framework.BundleContext;

public final class FrameworkInit
extends AbstractFrameworkService {
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();

    FrameworkInit() {
        super(InternalServices.FRAMEWORK_STATE_INIT);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkState> builder) {
        builder.addDependency(InternalServices.FRAMEWORK_STATE_CREATE, FrameworkState.class, this.injectedFramework);
        builder.addDependencies(new ServiceName[]{InternalServices.FRAMEWORK_CORE_SERVICES});
        builder.addDependencies(new ServiceName[]{IntegrationServices.BOOTSTRAP_BUNDLES_INSTALL, IntegrationServices.BOOTSTRAP_BUNDLES_COMPLETE});
        builder.addDependencies(new ServiceName[]{IntegrationServices.PERSISTENT_BUNDLES_INSTALL, IntegrationServices.PERSISTENT_BUNDLES_COMPLETE});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext context) throws StartException {
        FrameworkLogger.LOGGER.debugf("OSGi Framework initialized", new Object[0]);
    }

    public FrameworkState getValue() {
        return (FrameworkState)this.injectedFramework.getValue();
    }

    static class FrameworkInitialized
    extends AbstractIntegrationService<BundleContext> {
        private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
        private final ServiceController.Mode initialMode;

        FrameworkInitialized(ServiceController.Mode initialMode) {
            super(Services.FRAMEWORK_INIT);
            this.initialMode = initialMode;
        }

        @Override
        protected void addServiceDependencies(ServiceBuilder<BundleContext> builder) {
            builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedBundleContext);
            builder.addDependency(InternalServices.FRAMEWORK_STATE_INIT);
            builder.setInitialMode(this.initialMode);
        }

        public BundleContext getValue() throws IllegalStateException {
            return (BundleContext)this.injectedBundleContext.getValue();
        }
    }
}

