/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.modules.ClassSpec;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.filter.PathFilter;
import org.jboss.osgi.framework.internal.BundleReferenceClassLoader;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.LazyActivationTracker;

final class HostBundleClassLoader
extends BundleReferenceClassLoader<HostBundleState> {
    private final PathFilter lazyFilter;

    private HostBundleClassLoader(ModuleClassLoader.Configuration configuration, HostBundleState bundleState, PathFilter lazyFilter) {
        super(configuration, bundleState);
        this.lazyFilter = lazyFilter;
    }

    protected void preDefine(ClassSpec classSpec, String className) {
        String path;
        if (((HostBundleState)((Object)this.getBundleState())).awaitLazyActivation() && this.lazyFilter.accept(path = className.substring(0, className.lastIndexOf(46)).replace('.', '/'))) {
            LazyActivationTracker.preDefineClass((HostBundleState)((Object)this.getBundleState()), className);
        }
    }

    protected void postDefine(ClassSpec classSpec, Class<?> definedClass) {
        String path;
        if (((HostBundleState)((Object)this.getBundleState())).awaitLazyActivation() && this.lazyFilter.accept(path = definedClass.getPackage().getName().replace('.', '/'))) {
            LazyActivationTracker.postDefineClass((HostBundleState)((Object)this.getBundleState()), definedClass);
        }
    }

    static class Factory
    implements ModuleClassLoaderFactory {
        private HostBundleState bundleState;
        private PathFilter lazyFilter;

        public Factory(HostBundleState bundleState, PathFilter lazyFilter) {
            this.bundleState = bundleState;
            this.lazyFilter = lazyFilter;
        }

        public ModuleClassLoader create(ModuleClassLoader.Configuration configuration) {
            return new HostBundleClassLoader(configuration, this.bundleState, this.lazyFilter);
        }
    }
}

