/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleResolvedService;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.UserBundleInstalledService;
import org.jboss.osgi.framework.spi.ModuleLoaderPlugin;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.BundleException;

final class HostBundleInstalledService
extends UserBundleInstalledService<HostBundleState, HostBundleRevision> {
    static ServiceName addService(ServiceTarget serviceTarget, FrameworkState frameworkState, Deployment dep, ServiceListener<XBundle> listener) throws BundleException {
        ServiceName serviceName = frameworkState.getBundleManager().getServiceName(dep, 2);
        HostBundleInstalledService service = new HostBundleInstalledService(frameworkState, dep);
        ServiceBuilder builder = serviceTarget.addService(serviceName, new ServiceTracker.SynchronousListenerServiceWrapper<HostBundleState>(service));
        builder.addDependency(InternalServices.FRAMEWORK_CORE_SERVICES);
        if (listener != null) {
            builder.addListener(listener);
        }
        builder.install();
        return serviceName;
    }

    private HostBundleInstalledService(FrameworkState frameworkState, Deployment dep) throws BundleException {
        super(frameworkState, dep);
    }

    @Override
    HostBundleRevision createBundleRevision(Deployment deployment, OSGiMetaData metadata, BundleStoragePlugin.InternalStorageState storageState) throws BundleException {
        return new HostBundleRevision(this.getFrameworkState(), deployment, metadata, storageState);
    }

    @Override
    HostBundleState createBundleState(HostBundleRevision revision, ServiceName serviceName) {
        return new HostBundleState(this.getFrameworkState(), revision, serviceName);
    }

    @Override
    void createResolvedService(ServiceTarget serviceTarget, HostBundleRevision userRev) {
        ModuleManagerPlugin moduleManager = this.getFrameworkState().getModuleManagerPlugin();
        ModuleLoaderPlugin moduleLoader = this.getFrameworkState().getModuleLoaderPlugin();
        ModuleIdentifier identifier = moduleManager.getModuleIdentifier((XBundleRevision)userRev);
        ServiceName moduleServiceName = moduleLoader.getModuleServiceName(identifier);
        HostBundleResolvedService.addService(serviceTarget, (HostBundleState)this.getBundleState(), moduleServiceName);
    }
}

