/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.DefaultBundleLifecycleHandler;
import org.jboss.osgi.framework.internal.DefaultBundleLifecyclePlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleContext;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.LazyActivationTracker;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleLifecyclePlugin;
import org.jboss.osgi.framework.spi.BundleLock;
import org.jboss.osgi.framework.spi.StartLevelPlugin;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

final class HostBundleState
extends UserBundleState {
    private final AtomicBoolean alreadyStarting = new AtomicBoolean();
    private final AtomicBoolean awaitLazyActivation = new AtomicBoolean();
    BundleActivator bundleActivator;

    HostBundleState(FrameworkState frameworkState, HostBundleRevision brev, ServiceName serviceName) {
        super(frameworkState, brev, serviceName);
        ModuleManagerPlugin moduleManager = frameworkState.getModuleManagerPlugin();
        ModuleIdentifier moduleIdentifier = moduleManager.getModuleIdentifier((XBundleRevision)brev);
        brev.addAttachment(ModuleIdentifier.class, moduleIdentifier);
    }

    static HostBundleState assertBundleState(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        assert (bundleState instanceof HostBundleState) : "Not a HostBundleState: " + (Object)((Object)bundleState);
        return (HostBundleState)bundleState;
    }

    @Override
    public BundleContext getBundleContext() {
        return super.getBundleContext();
    }

    public boolean isFragment() {
        return false;
    }

    @Override
    public HostBundleRevision getBundleRevision() {
        return (HostBundleRevision)super.getBundleRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        LazyActivationTracker.startTracking(this, className);
        try {
            Class<?> loadedClass = super.loadClass(className);
            LazyActivationTracker.processLoadedClass(loadedClass);
            Class<?> clazz = loadedClass;
            return clazz;
        }
        finally {
            LazyActivationTracker.stopTracking(this, className);
        }
    }

    @Override
    void initLazyActivation() {
        this.awaitLazyActivation.set(this.isActivationLazy());
    }

    @Override
    HostBundleContext createContextInternal() {
        return new HostBundleContext(this);
    }

    @Override
    HostBundleRevision createUpdateRevision(Deployment dep, OSGiMetaData metadata, BundleStoragePlugin.InternalStorageState storageState) throws BundleException {
        return new HostBundleRevision(this.getFrameworkState(), dep, metadata, storageState);
    }

    boolean isActivationLazy() {
        ActivationPolicyMetaData activationPolicy = this.getActivationPolicy();
        String policyType = activationPolicy != null ? activationPolicy.getType() : null;
        return "lazy".equals(policyType);
    }

    ActivationPolicyMetaData getActivationPolicy() {
        return this.getOSGiMetaData().getBundleActivationPolicy();
    }

    boolean awaitLazyActivation() {
        return this.awaitLazyActivation.get();
    }

    void activateLazily() throws BundleException {
        if (this.awaitLazyActivation.getAndSet(false) && this.startLevelValidForStart()) {
            int options = 1;
            if (this.isBundleActivationPolicyUsed()) {
                options |= 2;
            }
            FrameworkLogger.LOGGER.debugf("Lazy activation of: %s", (Object)this);
            this.startInternal(options);
        }
    }

    void setBundleActivationPolicyUsed(boolean usePolicy) {
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        storageState.setBundleActivationPolicyUsed(usePolicy);
    }

    boolean isAlreadyStarting() {
        return this.alreadyStarting.get();
    }

    Set<UserBundleState> getDependentBundles() {
        HashSet<UserBundleState> result = new HashSet<UserBundleState>();
        if (this.isResolved()) {
            BundleWiring wiring = this.getBundleRevision().getWiring();
            List wires = wiring.getRequiredResourceWires(null);
            for (Wire wire : wires) {
                BundleRevision brev = (BundleRevision)wire.getProvider();
                Bundle bundle2 = brev.getBundle();
                if (!(bundle2 instanceof UserBundleState)) continue;
                result.add((UserBundleState)bundle2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startInternal(int options) throws BundleException {
        this.aquireBundleLock(BundleLock.LockMethod.START);
        this.alreadyStarting.set(true);
        try {
            boolean useActivationPolicy;
            this.assertStartConditions();
            if (this.getState() == 32) {
                return;
            }
            FrameworkLogger.LOGGER.debugf("Starting bundle: %s", (Object)this);
            if (!this.startLevelValidForStart()) {
                if ((options & 1) != 0) {
                    throw FrameworkMessages.MESSAGES.cannotStartBundleDueToStartLevel();
                }
                FrameworkLogger.LOGGER.debugf("Start level [%d] not valid for: %s", this.getBundleStartLevel(), (Object)this);
                this.persistAutoStartSettings(options);
                return;
            }
            this.persistAutoStartSettings(options);
            if (!this.ensureResolved(true)) {
                ResolutionException resex = this.getLastResolutionException();
                throw FrameworkMessages.MESSAGES.cannotResolveBundle(resex, (Bundle)this);
            }
            if (this.getBundleContextInternal() == null) {
                this.createBundleContext();
            }
            boolean bl = useActivationPolicy = (options & 2) != 0;
            if (this.awaitLazyActivation.get() && useActivationPolicy) {
                this.transitionToStarting(options);
            } else {
                this.transitionToActive(options);
            }
        }
        finally {
            this.alreadyStarting.set(false);
            this.releaseBundleLock(BundleLock.LockMethod.START);
        }
    }

    @Override
    void stopInternal(int options) throws BundleException {
        BundleLifecyclePlugin lifecycle = this.getCoreServices().getBundleLifecyclePlugin();
        lifecycle.stop(this, options, DefaultBundleLifecycleHandler.INSTANCE);
    }

    private void assertStartConditions() throws BundleException {
        List requiredEnvs = this.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (requiredEnvs != null) {
            boolean foundSupportedEnv = false;
            String frameworkEnvProp = (String)this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
            List<String> availableEnvs = Arrays.asList(frameworkEnvProp.split("[,\\s]+"));
            for (String aux : requiredEnvs) {
                if (!availableEnvs.contains(aux)) continue;
                foundSupportedEnv = true;
                break;
            }
            if (!foundSupportedEnv) {
                throw FrameworkMessages.MESSAGES.unsupportedExecutionEnvironment(requiredEnvs, availableEnvs);
            }
        }
    }

    private void persistAutoStartSettings(int options) {
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
            boolean activationPolicyUsed = (options & 2) != 0;
            this.setBundleActivationPolicyUsed(activationPolicyUsed);
        }
    }

    private void transitionToStarting(int options) throws BundleException {
        if (this.getState() == 8) {
            return;
        }
        this.changeState(8, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionToActive(int options) throws BundleException {
        BundleLifecyclePlugin lifecycle = this.getCoreServices().getBundleLifecyclePlugin();
        if (lifecycle instanceof DefaultBundleLifecyclePlugin) {
            lifecycle.start(this, options, DefaultBundleLifecycleHandler.INSTANCE);
        } else {
            this.releaseBundleLock(BundleLock.LockMethod.START);
            try {
                lifecycle.start(this, options, DefaultBundleLifecycleHandler.INSTANCE);
            }
            finally {
                this.aquireBundleLock(BundleLock.LockMethod.START);
            }
        }
    }

    private int getBundleStartLevel() {
        StartLevelPlugin startLevelPlugin = this.getCoreServices().getStartLevelPlugin();
        return startLevelPlugin.getBundleStartLevel((Bundle)this);
    }

    void setPersistentlyStarted(boolean started) {
        StartLevelPlugin startLevelPlugin = this.getCoreServices().getStartLevelPlugin();
        startLevelPlugin.setBundlePersistentlyStarted(this, started);
    }

    private boolean startLevelValidForStart() {
        StartLevelPlugin startLevelPlugin = this.getCoreServices().getStartLevelPlugin();
        return startLevelPlugin.getBundleStartLevel((Bundle)this) <= startLevelPlugin.getStartLevel();
    }

    private boolean isBundleActivationPolicyUsed() {
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }
}

