/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptorService;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.deployment.internal.InvocationContextImpl;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.spi.AttachmentSupport;
import org.jboss.osgi.spi.Attachments;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class LifecycleInterceptorPlugin
extends AbstractIntegrationService<LifecycleInterceptorPlugin>
implements LifecycleInterceptorService {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private AbstractLifecycleInterceptorService delegate;
    private ServiceRegistration registration;

    LifecycleInterceptorPlugin() {
        super(InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<LifecycleInterceptorPlugin> builder) {
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        final BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.delegate = new AbstractLifecycleInterceptorService(systemContext){

            protected InvocationContext getInvocationContext(Bundle bundle2) {
                if (bundle2 == null) {
                    throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
                }
                UserBundleState userBundle = UserBundleState.assertBundleState(bundle2);
                Deployment dep = userBundle.getDeployment();
                InvocationContext inv = (InvocationContext)dep.getAttachment(InvocationContext.class);
                if (inv == null) {
                    RevisionContent revContent = userBundle.getFirstContentRoot();
                    VirtualFile rootFile = revContent != null ? revContent.getVirtualFile() : null;
                    LifecycleInterceptorAttachments att = new LifecycleInterceptorAttachments();
                    inv = new InvocationContextImpl(systemContext, (Bundle)userBundle, rootFile, (Attachments)att);
                    dep.addAttachment(InvocationContext.class, (Object)inv);
                }
                return inv;
            }
        };
        this.registration = systemContext.registerService(LifecycleInterceptorService.class.getName(), (Object)this.delegate, null);
        this.delegate.open();
    }

    public void stop(StopContext context) {
        this.delegate.close();
        this.registration.unregister();
    }

    public LifecycleInterceptorPlugin getValue() {
        return this;
    }

    public void handleStateChange(int state, Bundle bundle2) {
        if (this.delegate != null) {
            this.delegate.handleStateChange(state, bundle2);
        }
    }

    static class LifecycleInterceptorAttachments
    extends AttachmentSupport {
        LifecycleInterceptorAttachments() {
        }
    }
}

