/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;

final class LockManagerPlugin
extends AbstractIntegrationService<LockManagerPlugin> {
    private final ReentrantLock frameworkLock = new ReentrantLock();
    private RuntimeException lastLockAquisition;

    LockManagerPlugin() {
        super(InternalServices.LOCK_MANAGER_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<LockManagerPlugin> builder) {
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public LockManagerPlugin getValue() throws IllegalStateException {
        return this;
    }

    ReentrantLock getFrameworkLock() {
        return this.frameworkLock;
    }

    void aquireFrameworkLock() throws TimeoutException {
        this.aquireFrameworkLock(30L, TimeUnit.SECONDS);
    }

    void aquireFrameworkLock(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            FrameworkLogger.LOGGER.tracef("Aquire framework lock", new Object[0]);
            if (!this.frameworkLock.tryLock(timeout, unit)) {
                throw FrameworkMessages.MESSAGES.cannotAquireFrameworkLock();
            }
            if (FrameworkLogger.LOGGER.isDebugEnabled()) {
                this.lastLockAquisition = new RuntimeException();
            }
        }
        catch (InterruptedException ex) {
            throw FrameworkMessages.MESSAGES.cannotAquireFrameworkLock();
        }
    }

    void releaseFrameworkLock() {
        FrameworkLogger.LOGGER.tracef("Release framework lock", new Object[0]);
        this.lastLockAquisition = null;
        this.frameworkLock.unlock();
    }

    void assertNotHeldByCurrentThread() {
        if (this.frameworkLock.isHeldByCurrentThread()) {
            throw FrameworkMessages.MESSAGES.frameworkLockHeldByCurrentThread(this.lastLockAquisition);
        }
    }
}

