/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractBundleWire;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.LockManagerPlugin;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.ModuleLoaderPlugin;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.felix.StatelessResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

final class ResolverPlugin
extends AbstractIntegrationService<ResolverPlugin>
implements XResolver {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<NativeCodePlugin> injectedNativeCode = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private final InjectedValue<ModuleLoaderPlugin> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<LockManagerPlugin> injectedLockManager = new InjectedValue();
    private XResolver resolver;

    ResolverPlugin() {
        super(Services.RESOLVER);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<ResolverPlugin> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(InternalServices.NATIVE_CODE_PLUGIN, NativeCodePlugin.class, this.injectedNativeCode);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, this.injectedModuleManager);
        builder.addDependency(IntegrationServices.MODULE_LOADER_PLUGIN, ModuleLoaderPlugin.class, this.injectedModuleLoader);
        builder.addDependency(InternalServices.LOCK_MANAGER_PLUGIN, LockManagerPlugin.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        this.resolver = new StatelessResolver();
    }

    public void stop(StopContext context) {
        this.resolver = null;
    }

    public ResolverPlugin getValue() {
        return this;
    }

    public XResolveContext createResolveContext(XEnvironment environment, Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        Collection<Resource> manres = this.filterSingletons(mandatory);
        HashSet<Resource> optres = new HashSet<Resource>(optional != null ? optional : Collections.emptySet());
        this.appendOptionalFragments(mandatory, optres);
        this.appendOptionalHostBundles(mandatory, optres);
        return this.resolver.createResolveContext(env, manres, optres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Resource, List<Wire>> resolve(ResolveContext context) throws ResolutionException {
        this.aquireFrameworkLock();
        try {
            Map map = this.resolver.resolve(context);
            return map;
        }
        finally {
            this.releaseFrameworkLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Resource, Wiring> resolveAndApply(XResolveContext context) throws ResolutionException {
        Map<Resource, Wiring> wirings;
        Map wiremap;
        this.aquireFrameworkLock();
        try {
            wiremap = this.resolver.resolve((ResolveContext)context);
            wirings = this.applyResolverResults(wiremap);
        }
        finally {
            this.releaseFrameworkLock();
        }
        this.sendBundleResolvedEvents(wiremap);
        return wirings;
    }

    Map<Resource, Wiring> resolveAndApply(Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) throws ResolutionException {
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        XResolveContext context = this.createResolveContext(env, mandatory, optional);
        return this.resolveAndApply(context);
    }

    private void appendOptionalFragments(Collection<? extends Resource> mandatory, Collection<Resource> optional) {
        Collection<Capability> hostcaps = this.getHostCapabilities(mandatory);
        if (!hostcaps.isEmpty()) {
            optional.addAll(this.findAttachableFragments(hostcaps));
        }
    }

    private void appendOptionalHostBundles(Collection<? extends Resource> mandatory, Collection<Resource> optional) {
        for (Resource resource : mandatory) {
            for (Requirement req : resource.getRequirements("osgi.wiring.package")) {
                XPackageRequirement preq = (XPackageRequirement)req;
                if (!preq.isOptional()) continue;
                BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
                for (XBundle bundle2 : bundleManager.getBundles(2)) {
                    XBundleRevision auxrev = bundle2.getBundleRevision();
                    if (bundle2.isFragment() || mandatory.contains(auxrev)) continue;
                    optional.add((Resource)auxrev);
                }
                return;
            }
        }
    }

    private Collection<Capability> getHostCapabilities(Collection<? extends Resource> resources) {
        HashSet<Capability> result = new HashSet<Capability>();
        for (Resource resource : resources) {
            List caps = resource.getCapabilities("osgi.wiring.host");
            if (caps.size() != 1) continue;
            result.add((Capability)caps.get(0));
        }
        return result;
    }

    private Collection<Resource> filterSingletons(Collection<? extends Resource> resources) {
        HashMap<String, XResource> singletons = new HashMap<String, XResource>();
        ArrayList<? extends Resource> result = new ArrayList<Resource>(resources);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            XResource xres = (XResource)iterator.next();
            XIdentityCapability icap = xres.getIdentityCapability();
            if (!icap.isSingleton()) continue;
            if (singletons.get(icap.getSymbolicName()) != null) {
                iterator.remove();
                continue;
            }
            singletons.put(icap.getSymbolicName(), xres);
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<XResource> findAttachableFragments(Collection<? extends Capability> hostcaps) {
        HashSet<XResource> result = new HashSet<XResource>();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        for (XResource res : env.getResources(new String[]{"osgi.fragment"})) {
            Requirement req = (Requirement)res.getRequirements("osgi.wiring.host").get(0);
            XRequirement xreq = (XRequirement)req;
            for (Capability capability : hostcaps) {
                if (!xreq.matches(capability)) continue;
                result.add(res);
            }
        }
        if (!result.isEmpty()) {
            FrameworkLogger.LOGGER.debugf("Adding attachable fragments: %s", result);
        }
        return result;
    }

    private Map<Resource, Wiring> applyResolverResults(Map<Resource, List<Wire>> wiremap) throws ResolutionException {
        Resource res;
        LinkedHashMap<BundleRevision, List<BundleWire>> brevmap = new LinkedHashMap<BundleRevision, List<BundleWire>>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            ArrayList<AbstractBundleWire> bwires = new ArrayList<AbstractBundleWire>();
            ArrayList<AbstractBundleWire> wires = new ArrayList<AbstractBundleWire>();
            for (Wire wire : entry.getValue()) {
                AbstractBundleWire bwire = new AbstractBundleWire(wire);
                bwires.add(bwire);
                wires.add(bwire);
            }
            res = entry.getKey();
            brevmap.put((BundleRevision)res, bwires);
            wiremap.put(res, wires);
        }
        this.attachFragmentsToHost(brevmap);
        try {
            this.resolveNativeCodeLibraries(brevmap);
        }
        catch (BundleException ex) {
            throw new ResolutionException((Throwable)ex);
        }
        this.addModules(brevmap);
        this.createModuleServices(brevmap);
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        Map wirings = env.updateWiring(wiremap);
        for (Map.Entry entry : wirings.entrySet()) {
            res = (XBundleRevision)entry.getKey();
            res.addAttachment(Wiring.class, entry.getValue());
        }
        this.setBundleStatesToResolved(brevmap);
        return wirings;
    }

    private void attachFragmentsToHost(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!brev.isFragment()) continue;
            FragmentBundleRevision fragRev = (FragmentBundleRevision)brev;
            for (BundleWire wire : entry.getValue()) {
                BundleCapability cap = wire.getCapability();
                if (!"osgi.wiring.host".equals(cap.getNamespace())) continue;
                HostBundleRevision hostRev = (HostBundleRevision)cap.getResource();
                fragRev.attachToHost(hostRev);
            }
        }
    }

    private void resolveNativeCodeLibraries(Map<BundleRevision, List<BundleWire>> wiremap) throws BundleException {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            UserBundleRevision userRev;
            Deployment deployment;
            NativeLibraryMetaData libMetaData;
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (!(brev instanceof UserBundleRevision) || (libMetaData = (NativeLibraryMetaData)(deployment = (userRev = (UserBundleRevision)brev).getDeployment()).getAttachment(NativeLibraryMetaData.class)) == null) continue;
            NativeCodePlugin nativeCodePlugin = (NativeCodePlugin)this.injectedNativeCode.getValue();
            nativeCodePlugin.resolveNativeCode(userRev);
        }
    }

    private void addModules(Map<BundleRevision, List<BundleWire>> wiremap) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)this.injectedModuleManager.getValue();
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            if (brev.isFragment()) continue;
            List<BundleWire> wires = wiremap.get(brev);
            ModuleIdentifier identifier = moduleManager.addModule(brev, wires);
            brev.addAttachment(ModuleIdentifier.class, (Object)identifier);
        }
    }

    private void createModuleServices(Map<BundleRevision, List<BundleWire>> wiremap) {
        ModuleManagerPlugin moduleManager = (ModuleManagerPlugin)this.injectedModuleManager.getValue();
        ModuleLoaderPlugin moduleLoader = (ModuleLoaderPlugin)this.injectedModuleLoader.getValue();
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 == null || bundle2.getBundleId() == 0L || brev.isFragment()) continue;
            ModuleIdentifier identifier = moduleManager.getModuleIdentifier(brev);
            moduleLoader.createModuleService(brev, identifier);
        }
    }

    private void setBundleStatesToResolved(Map<BundleRevision, List<BundleWire>> wiremap) {
        for (Map.Entry<BundleRevision, List<BundleWire>> entry : wiremap.entrySet()) {
            Bundle bundle2 = entry.getKey().getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            bundleState.changeState(4, 0);
        }
    }

    private void sendBundleResolvedEvents(Map<Resource, List<Wire>> wiremap) {
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XBundleRevision brev = (XBundleRevision)entry.getKey();
            XBundle bundle2 = brev.getBundle();
            if (!(bundle2 instanceof AbstractBundleState)) continue;
            AbstractBundleState bundleState = (AbstractBundleState)bundle2;
            if (bundleManager.isFrameworkCreated()) {
                bundleState.fireBundleEvent(32);
            }
            ServiceName serviceName = bundleState.getServiceName(4);
            bundleManager.setServiceMode(serviceName, ServiceController.Mode.ACTIVE);
        }
    }

    private void aquireFrameworkLock() throws ResolutionException {
        try {
            LockManagerPlugin lockManager = (LockManagerPlugin)this.injectedLockManager.getValue();
            lockManager.aquireFrameworkLock();
        }
        catch (TimeoutException ex) {
            throw new ResolutionException((Throwable)ex);
        }
    }

    private void releaseFrameworkLock() {
        LockManagerPlugin lockManager = (LockManagerPlugin)this.injectedLockManager.getValue();
        lockManager.releaseFrameworkLock();
    }
}

