/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NoFilter;
import org.jboss.osgi.framework.internal.RemoveOnlyCollection;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

final class ServiceManagerPlugin
extends AbstractIntegrationService<ServiceManagerPlugin> {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkEventsPlugin> injectedFrameworkEvents = new InjectedValue();
    private final InjectedValue<ModuleManagerPlugin> injectedModuleManager = new InjectedValue();
    private final Map<String, List<ServiceState>> serviceContainer = new HashMap<String, List<ServiceState>>();
    private final AtomicLong identityGenerator = new AtomicLong();

    ServiceManagerPlugin() {
        super(InternalServices.SERVICE_MANAGER_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<ServiceManagerPlugin> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(InternalServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEventsPlugin.class, this.injectedFrameworkEvents);
        builder.addDependency(InternalServices.MODULE_MANGER_PLUGIN, ModuleManagerPlugin.class, this.injectedModuleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ServiceManagerPlugin getValue() {
        return this;
    }

    FrameworkEventsPlugin getFrameworkEventsPlugin() {
        return (FrameworkEventsPlugin)this.injectedFrameworkEvents.getValue();
    }

    long getNextServiceId() {
        return this.identityGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceState registerService(AbstractBundleState bundleState, String[] classNames, final Object serviceValue, Dictionary properties) {
        assert (classNames != null && classNames.length > 0) : "Null service classes";
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkEventsPlugin();
        Collection<ListenerHook.ListenerInfo> listenerInfos = null;
        if (serviceValue instanceof ListenerHook) {
            listenerInfos = eventsPlugin.getServiceListenerInfos(null);
        }
        ServiceState.ValueProvider valueProvider = new ServiceState.ValueProvider(){

            @Override
            public boolean isFactoryValue() {
                return serviceValue instanceof ServiceFactory;
            }

            @Override
            public Object getValue() {
                return serviceValue;
            }
        };
        long serviceId = this.getNextServiceId();
        ServiceState serviceState = new ServiceState(this, bundleState, serviceId, classNames, valueProvider, properties);
        FrameworkLogger.LOGGER.debugf("Register service: %s", serviceState);
        Map<String, List<ServiceState>> map = this.serviceContainer;
        synchronized (map) {
            for (String className : classNames) {
                List<ServiceState> serviceStates = this.serviceContainer.get(className);
                if (serviceStates != null) {
                    serviceStates.add(serviceState);
                    continue;
                }
                serviceStates = new CopyOnWriteArrayList<ServiceState>();
                serviceStates.add(serviceState);
                this.serviceContainer.put(className, serviceStates);
            }
        }
        bundleState.addRegisteredService(serviceState);
        if (serviceValue instanceof ListenerHook) {
            ListenerHook listenerHook = (ListenerHook)serviceValue;
            listenerHook.added(listenerInfos);
        }
        eventsPlugin.fireServiceEvent(bundleState, 1, serviceState);
        return serviceState;
    }

    ServiceState getServiceReference(AbstractBundleState bundleState, String clazz) {
        assert (clazz != null) : "Null clazz";
        boolean checkAssignable = bundleState.getBundleId() != 0L;
        List<ServiceState> result = this.getServiceReferencesInternal(bundleState, clazz, NoFilter.INSTANCE, checkAssignable);
        if ((result = this.processFindHooks(bundleState, clazz, null, true, result)).isEmpty()) {
            return null;
        }
        int lastIndex = result.size() - 1;
        return result.get(lastIndex);
    }

    List<ServiceState> getServiceReferences(AbstractBundleState bundleState, String clazz, String filterStr, boolean checkAssignable) throws InvalidSyntaxException {
        Filter filter = NoFilter.INSTANCE;
        if (filterStr != null) {
            filter = FrameworkUtil.createFilter((String)filterStr);
        }
        List<ServiceState> result = this.getServiceReferencesInternal(bundleState, clazz, filter, checkAssignable);
        result = this.processFindHooks(bundleState, clazz, filterStr, checkAssignable, result);
        return result;
    }

    private List<ServiceState> getServiceReferencesInternal(AbstractBundleState bundleState, String className, Filter filter, boolean checkAssignable) {
        assert (bundleState != null) : "Null bundleState";
        assert (filter != null) : "Null filter";
        HashSet<ServiceState> initialSet = new HashSet<ServiceState>();
        if (className != null) {
            List<ServiceState> list = this.serviceContainer.get(className);
            if (list != null) {
                initialSet.addAll(list);
            }
        } else {
            for (List<ServiceState> list : this.serviceContainer.values()) {
                initialSet.addAll(list);
            }
        }
        if (initialSet.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceState> resultset = new HashSet<ServiceState>();
        for (ServiceState serviceState : initialSet) {
            if (!this.isMatchingService(bundleState, serviceState, className, filter, checkAssignable)) continue;
            resultset.add(serviceState);
        }
        ArrayList resultList = new ArrayList(resultset);
        if (resultList.size() > 1) {
            Collections.sort(resultList, ServiceReferenceComparator.getInstance());
        }
        return Collections.unmodifiableList(resultList);
    }

    private boolean isMatchingService(AbstractBundleState bundleState, ServiceState serviceState, String clazzName, Filter filter, boolean checkAssignable) {
        if (serviceState.isUnregistered() || !filter.match((ServiceReference)serviceState)) {
            return false;
        }
        if (!checkAssignable || clazzName == null) {
            return true;
        }
        return serviceState.isAssignableTo((Bundle)bundleState, clazzName);
    }

    Object getService(AbstractBundleState bundleState, ServiceState serviceState) {
        if (serviceState.isUnregistered()) {
            return null;
        }
        bundleState.addServiceInUse(serviceState);
        serviceState.addUsingBundle(bundleState);
        Object value = serviceState.getScopedValue(bundleState);
        if (value == null) {
            bundleState.removeServiceInUse(serviceState);
            serviceState.removeUsingBundle(bundleState);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterService(ServiceState serviceState) {
        ServiceState serviceState2 = serviceState;
        synchronized (serviceState2) {
            if (serviceState.isUnregistered()) {
                return;
            }
            Map<String, List<ServiceState>> map = this.serviceContainer;
            synchronized (map) {
                for (String className : serviceState.getClassNames()) {
                    FrameworkLogger.LOGGER.debugf("Unregister service: %s", className);
                    try {
                        List<ServiceState> serviceStates = this.serviceContainer.get(className);
                        if (serviceStates == null) continue;
                        serviceStates.remove(serviceState);
                    }
                    catch (RuntimeException ex) {
                        FrameworkLogger.LOGGER.errorCannotRemoveService(ex, className);
                    }
                }
            }
            XBundle serviceOwner = serviceState.getServiceOwner();
            FrameworkEventsPlugin eventsPlugin = (FrameworkEventsPlugin)this.injectedFrameworkEvents.getValue();
            eventsPlugin.fireServiceEvent(serviceOwner, 4, serviceState);
            for (AbstractBundleState bundleState : serviceState.getUsingBundlesInternal()) {
                while (this.ungetService(bundleState, serviceState)) {
                }
            }
            if (serviceOwner instanceof AbstractBundleState) {
                AbstractBundleState ownerState = AbstractBundleState.assertBundleState((Bundle)serviceOwner);
                ownerState.removeRegisteredService(serviceState);
            }
        }
    }

    boolean ungetService(AbstractBundleState bundleState, ServiceState serviceState) {
        serviceState.ungetScopedValue(bundleState);
        int useCount = bundleState.removeServiceInUse(serviceState);
        if (useCount == 0) {
            serviceState.removeUsingBundle(bundleState);
        }
        return useCount >= 0;
    }

    private List<ServiceState> processFindHooks(AbstractBundleState bundle2, String clazz, String filterStr, boolean checkAssignable, List<ServiceState> serviceStates) {
        BundleContext context = bundle2.getBundleContext();
        List<ServiceState> hookRefs = this.getServiceReferencesInternal(bundle2, FindHook.class.getName(), NoFilter.INSTANCE, true);
        if (hookRefs.isEmpty()) {
            return serviceStates;
        }
        if (clazz != null && clazz.startsWith(FindHook.class.getPackage().getName())) {
            return serviceStates;
        }
        ArrayList<ServiceState> sortedHookRefs = new ArrayList<ServiceState>(hookRefs);
        Collections.reverse(sortedHookRefs);
        ArrayList<FindHook> hooks = new ArrayList<FindHook>();
        for (ServiceReference serviceReference : sortedHookRefs) {
            hooks.add((FindHook)context.getService(serviceReference));
        }
        Collection hookParam = new ArrayList<ServiceReference>();
        for (ServiceState aux : serviceStates) {
            hookParam.add(aux.getReference());
        }
        hookParam = new RemoveOnlyCollection(hookParam);
        for (FindHook hook : hooks) {
            try {
                hook.find(context, clazz, filterStr, !checkAssignable, hookParam);
            }
            catch (Exception ex) {
                FrameworkLogger.LOGGER.warnErrorWhileCallingFindHook(ex, hook);
            }
        }
        ArrayList<ServiceState> arrayList = new ArrayList<ServiceState>();
        for (ServiceReference aux : hookParam) {
            ServiceState serviceState = ServiceState.assertServiceState(aux);
            arrayList.add(serviceState);
        }
        return arrayList;
    }
}

