/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FallbackLoader;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.ServiceReferenceComparator;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceRegistrationWrapper;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

final class ServiceState
implements ServiceRegistration,
ServiceReference {
    private final ServiceManagerPlugin serviceManager;
    private final XBundle ownerBundle;
    private final String[] classNames;
    private final long serviceId;
    private final ValueProvider valueProvider;
    private final ServiceReference reference;
    private ServiceRegistration registration;
    private Set<AbstractBundleState> usingBundles;
    private Map<Long, ServiceFactoryHolder> factoryValues;
    private CaseInsensitiveDictionary prevProperties;
    private CaseInsensitiveDictionary currProperties;

    ServiceState(ServiceManagerPlugin serviceManager, XBundle owner, long serviceId, String[] classNames, ValueProvider valueProvider, Dictionary properties) {
        assert (serviceManager != null) : "Null serviceManager";
        assert (owner != null) : "Null owner";
        assert (classNames != null && classNames.length > 0) : "Null clazzes";
        assert (valueProvider != null) : "Null valueProvider";
        this.serviceManager = serviceManager;
        this.ownerBundle = owner;
        this.serviceId = serviceId;
        this.valueProvider = valueProvider;
        this.classNames = classNames;
        if (!valueProvider.isFactoryValue() && !this.checkValidClassNames(owner, classNames, valueProvider.getValue())) {
            throw FrameworkMessages.MESSAGES.illegalArgumentInvalidObjectClass(Arrays.toString(classNames));
        }
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", serviceId);
        ((Dictionary)properties).put("objectClass", (Long)classNames);
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.registration = new ServiceRegistrationWrapper(this);
        this.reference = new ServiceReferenceWrapper(this);
    }

    static ServiceState assertServiceState(ServiceReference sref) {
        assert (sref != null) : "Null sref";
        if (sref instanceof ServiceReferenceWrapper) {
            sref = ((ServiceReferenceWrapper)sref).getServiceState();
        }
        return (ServiceState)sref;
    }

    long getServiceId() {
        return this.serviceId;
    }

    static ServiceName createServiceName(String clazz) {
        return InternalServices.SERVICE_BASE_NAME.append(new String[]{clazz});
    }

    Object getRawValue() {
        return this.valueProvider.getValue();
    }

    Object getScopedValue(AbstractBundleState bundleState) {
        if (!this.valueProvider.isFactoryValue()) {
            return this.valueProvider.getValue();
        }
        Object result = null;
        try {
            ServiceFactoryHolder factoryHolder;
            if (this.factoryValues == null) {
                this.factoryValues = new HashMap<Long, ServiceFactoryHolder>();
            }
            if ((factoryHolder = this.getFactoryHolder(bundleState)) == null) {
                ServiceFactory factory = (ServiceFactory)this.valueProvider.getValue();
                factoryHolder = new ServiceFactoryHolder(bundleState, factory);
                this.factoryValues.put(bundleState.getBundleId(), factoryHolder);
            }
            if ((result = factoryHolder.getService()) == null) {
                ServiceException sex = new ServiceException("Cannot get factory value", 2);
                FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
                eventsPlugin.fireFrameworkEvent((Bundle)bundleState, 2, (Throwable)sex);
            }
        }
        catch (Throwable th) {
            ServiceException sex = new ServiceException("Cannot get factory value", 3, th);
            FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
            eventsPlugin.fireFrameworkEvent((Bundle)bundleState, 2, (Throwable)sex);
        }
        return result;
    }

    void ungetScopedValue(AbstractBundleState bundleState) {
        ServiceFactoryHolder factoryHolder;
        if (this.valueProvider.isFactoryValue() && (factoryHolder = this.getFactoryHolder(bundleState)) != null) {
            try {
                factoryHolder.ungetService();
            }
            catch (RuntimeException rte) {
                ServiceException sex = new ServiceException("Cannot unget factory value", 3, (Throwable)rte);
                FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
                eventsPlugin.fireFrameworkEvent((Bundle)bundleState, 16, (Throwable)sex);
            }
        }
    }

    private ServiceFactoryHolder getFactoryHolder(AbstractBundleState bundleState) {
        return this.factoryValues != null ? this.factoryValues.get(bundleState.getBundleId()) : null;
    }

    ServiceRegistration getRegistration() {
        return this.registration;
    }

    List<String> getClassNames() {
        return Arrays.asList(this.classNames);
    }

    public ServiceReference getReference() {
        this.assertNotUnregistered();
        return this.reference;
    }

    public void unregister() {
        this.assertNotUnregistered();
        this.unregisterInternal();
    }

    void unregisterInternal() {
        this.serviceManager.unregisterService(this);
        this.usingBundles = null;
        this.registration = null;
    }

    public Object getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.currProperties.get((Object)key);
    }

    public String[] getPropertyKeys() {
        ArrayList result = new ArrayList();
        if (this.currProperties != null) {
            Enumeration keys = this.currProperties.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProperties(Dictionary properties) {
        this.assertNotUnregistered();
        this.prevProperties = this.currProperties;
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ((Dictionary)properties).put("service.id", this.currProperties.get((Object)"service.id"));
        ((Dictionary)properties).put("objectClass", this.currProperties.get((Object)"objectClass"));
        this.currProperties = new CaseInsensitiveDictionary(properties);
        FrameworkEventsPlugin eventsPlugin = this.serviceManager.getFrameworkEventsPlugin();
        eventsPlugin.fireServiceEvent(this.ownerBundle, 2, this);
    }

    Dictionary getPreviousProperties() {
        return this.prevProperties;
    }

    XBundle getServiceOwner() {
        return this.ownerBundle;
    }

    public Bundle getBundle() {
        if (this.isUnregistered()) {
            return null;
        }
        return this.ownerBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUsingBundle(AbstractBundleState bundleState) {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                this.usingBundles = new HashSet<AbstractBundleState>();
            }
            this.usingBundles.add(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUsingBundle(AbstractBundleState bundleState) {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles != null) {
                this.usingBundles.remove((Object)bundleState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<AbstractBundleState> getUsingBundlesInternal() {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(new HashSet<AbstractBundleState>(this.usingBundles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getUsingBundles() {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                return null;
            }
            HashSet<AbstractBundleState> bundles = new HashSet<AbstractBundleState>();
            for (AbstractBundleState aux : this.usingBundles) {
                bundles.add(aux);
            }
            return bundles.toArray(new Bundle[bundles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssignableTo(Bundle bundle2, String className) {
        Class<?> serviceClass;
        Class<?> targetClass;
        block16: {
            if (bundle2 == null) {
                throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
            }
            if (className == null) {
                throw FrameworkMessages.MESSAGES.illegalArgumentNull("className");
            }
            if (bundle2 == this.ownerBundle || className.startsWith("java.")) {
                return true;
            }
            int bundleState = bundle2.getState();
            if (bundleState == 1) {
                return false;
            }
            XBundleRevision bundleRev = ((XBundle)bundle2).getBundleRevision();
            ModuleClassLoader bundleClassLoader = bundleRev.getModuleClassLoader();
            if (bundleClassLoader == null) {
                FrameworkLogger.LOGGER.infof("NO CLASSLOADER [%s,%s] for: %s", bundle2, ConstantsHelper.bundleState((int)bundleState), className);
                return false;
            }
            FallbackLoader fallbackLoader = null;
            if (bundleRev instanceof HostBundleRevision) {
                fallbackLoader = ((HostBundleRevision)bundleRev).getFallbackLoader();
            }
            try {
                if (fallbackLoader != null) {
                    try {
                        fallbackLoader.lock();
                        fallbackLoader.setEnabled(false);
                        targetClass = bundleClassLoader.loadClass(className);
                        break block16;
                    }
                    finally {
                        fallbackLoader.setEnabled(true);
                        fallbackLoader.unlock();
                    }
                }
                targetClass = bundleClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.tracef("Requesting bundle [%s] cannot load class: %s", bundle2, className);
                return true;
            }
        }
        XBundleRevision ownerRev = this.ownerBundle.getBundleRevision();
        ModuleClassLoader ownerClassLoader = ownerRev.getModuleClassLoader();
        if (ownerClassLoader == null) {
            FrameworkLogger.LOGGER.tracef("Registrant bundle [%s] has no class loader for: %s", this.ownerBundle, className);
            return true;
        }
        try {
            serviceClass = ownerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            FrameworkLogger.LOGGER.tracef("Registrant bundle [%s] cannot load class: %s", this.ownerBundle, className);
            return true;
        }
        if (targetClass != serviceClass) {
            FrameworkLogger.LOGGER.tracef("Not assignable: %s", className);
            return false;
        }
        return true;
    }

    public int compareTo(Object sref) {
        if (!(sref instanceof ServiceReference)) {
            throw FrameworkMessages.MESSAGES.illegalArgumentInvalidServiceRef(sref);
        }
        Comparator<ServiceReference> comparator = ServiceReferenceComparator.getInstance();
        return comparator.compare(this, (ServiceReference)sref);
    }

    int getServiceRanking() {
        Object prop = this.getProperty("service.ranking");
        if (!(prop instanceof Integer)) {
            return 0;
        }
        return (Integer)prop;
    }

    boolean isUnregistered() {
        return this.registration == null;
    }

    void assertNotUnregistered() {
        if (this.isUnregistered()) {
            throw FrameworkMessages.MESSAGES.illegalStateServiceUnregistered(this);
        }
    }

    private boolean checkValidClassNames(XBundle bundleState, String[] classNames, Object value) {
        assert (bundleState != null) : "Null bundleState";
        assert (classNames != null && classNames.length > 0) : "Null service classes";
        assert (value != null) : "Null value";
        if (value instanceof ServiceFactory) {
            return true;
        }
        boolean result = true;
        for (String className : classNames) {
            if (className == null) {
                result = false;
                break;
            }
            try {
                Class<?> valueClass = value.getClass();
                Class<?> clazz = Class.forName(className, false, valueClass.getClassLoader());
                if (clazz.isAssignableFrom(valueClass)) continue;
                FrameworkLogger.LOGGER.errorServiceNotAssignable(className, clazz.getClassLoader(), valueClass.getName(), valueClass.getClassLoader());
                result = false;
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.errorCannotLoadService(className, (Bundle)bundleState);
                result = false;
            }
            break;
        }
        return result;
    }

    public String toString() {
        Hashtable<String, List<String>> props = new Hashtable<String, List<String>>((Map<String, List<String>>)this.currProperties);
        String[] classes = (String[])props.get("objectClass");
        props.put("objectClass", Arrays.asList(classes));
        return "ServiceState" + props;
    }

    class ServiceFactoryHolder {
        ServiceFactory factory;
        AbstractBundleState bundleState;
        AtomicInteger useCount;
        Object value;

        ServiceFactoryHolder(AbstractBundleState bundleState, ServiceFactory factory) {
            this.bundleState = bundleState;
            this.factory = factory;
            this.useCount = new AtomicInteger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getService() {
            if (this.useCount.get() == 0) {
                AbstractBundleState abstractBundleState = this.bundleState;
                synchronized (abstractBundleState) {
                    Object retValue = this.factory.getService((Bundle)this.bundleState, ServiceState.this.getRegistration());
                    if (retValue == null) {
                        return null;
                    }
                    if (!ServiceState.this.checkValidClassNames(ServiceState.this.ownerBundle, (String[])ServiceState.this.getProperty("objectClass"), retValue)) {
                        return null;
                    }
                    this.value = retValue;
                }
            }
            this.useCount.incrementAndGet();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ungetService() {
            if (this.useCount.get() == 0) {
                return;
            }
            if (this.useCount.decrementAndGet() == 0) {
                AbstractBundleState abstractBundleState = this.bundleState;
                synchronized (abstractBundleState) {
                    this.factory.ungetService((Bundle)this.bundleState, ServiceState.this.getRegistration(), this.value);
                    this.value = null;
                }
            }
        }
    }

    static interface ValueProvider {
        public boolean isFactoryValue();

        public Object getValue();
    }
}

