/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.util.ArrayList;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemPathsPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class SystemBundleService
extends AbstractBundleService<SystemBundleState>
implements IntegrationService<SystemBundleState> {
    private final InjectedValue<SystemPathsPlugin> injectedSystemPaths = new InjectedValue();
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironmentPlugin = new InjectedValue();
    private SystemBundleState bundleState;

    SystemBundleService(FrameworkState frameworkState) {
        super(frameworkState);
    }

    @Override
    public ServiceName getServiceName() {
        return InternalServices.SYSTEM_BUNDLE;
    }

    @Override
    public ServiceController<SystemBundleState> install(ServiceTarget serviceTarget, ServiceListener<Object> listener) {
        ServiceBuilder builder = serviceTarget.addService(this.getServiceName(), (Service)this);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironmentPlugin);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PLUGIN, SystemPathsPlugin.class, this.injectedSystemPaths);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, this.injectedBundleStorage);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.addListener(listener);
        return builder.install();
    }

    @Override
    public void start(StartContext context) throws StartException {
        BundleStoragePlugin.InternalStorageState storageState = null;
        try {
            OSGiMetaData metadata = this.createOSGiMetaData();
            storageState = this.createStorageState();
            SystemBundleRevision brev = new SystemBundleRevision(this.getFrameworkState(), metadata, storageState);
            brev.addAttachment(Long.class, new Long(0L));
            this.bundleState = this.createBundleState(brev);
            this.bundleState.changeState(8);
            this.addToEnvironment(brev);
            this.bundleState.createBundleContext();
            BundleManagerPlugin bundleManager = this.getBundleManager();
            bundleManager.injectedSystemBundle.inject((Object)this.bundleState);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                BundleStoragePlugin storagePlugin = (BundleStoragePlugin)this.injectedBundleStorage.getValue();
                storagePlugin.deleteStorageState(storageState);
            }
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    public void stop(StopContext context) {
        BundleManagerPlugin bundleManager = this.getBundleManager();
        bundleManager.injectedSystemBundle.uninject();
    }

    BundleStoragePlugin.InternalStorageState createStorageState() {
        try {
            BundleStoragePlugin storagePlugin = (BundleStoragePlugin)this.injectedBundleStorage.getValue();
            return storagePlugin.createStorageState(0L, "System Bundle", 0, null);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateSystemBundleStorage(ex);
        }
    }

    SystemBundleState createBundleState(SystemBundleRevision revision) {
        return new SystemBundleState(this.getFrameworkState(), revision);
    }

    @Override
    SystemBundleState getBundleState() {
        return this.bundleState;
    }

    private OSGiMetaData createOSGiMetaData() {
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)"system.bundle", (Version)Version.emptyVersion);
        SystemPathsPlugin systemPackages = (SystemPathsPlugin)this.injectedSystemPaths.getValue();
        ArrayList<String> exportedPackages = new ArrayList<String>();
        exportedPackages.addAll(systemPackages.getSystemPackages());
        for (String packageSpec : exportedPackages) {
            builder.addExportPackages(new String[]{packageSpec});
        }
        return builder.getOSGiMetaData();
    }

    private void addToEnvironment(SystemBundleRevision sysrev) {
        XEnvironment env = (XEnvironment)this.injectedEnvironmentPlugin.getValue();
        env.installResources(new XResource[]{sysrev});
    }
}

