/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleContext;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class SystemBundleState
extends AbstractBundleState {
    private final SystemBundleRevision systemRevision;

    SystemBundleState(FrameworkState frameworkState, SystemBundleRevision revision) {
        super(frameworkState, revision, 0L);
        this.systemRevision = revision;
    }

    static SystemBundleState assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof SystemBundleState) : "Not an SystemBundleState: " + bundle2;
        return (SystemBundleState)((Object)bundle2);
    }

    public List<XBundleRevision> getAllBundleRevisions() {
        return Collections.singletonList(this.systemRevision);
    }

    @Override
    ServiceName getServiceName(int state) {
        return InternalServices.SYSTEM_BUNDLE;
    }

    @Override
    public String getSymbolicName() {
        return "org.jboss.osgi.framework";
    }

    public String getLocation() {
        return "org.jboss.osgi.framework";
    }

    @Override
    public Version getVersion() {
        return BundleManagerPlugin.getFrameworkVersion();
    }

    @Override
    AbstractBundleContext createContextInternal() {
        return new SystemBundleContext(this);
    }

    @Override
    public SystemBundleRevision getBundleRevision() {
        return this.systemRevision;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        Object result = super.adapt(type);
        if (result == null) {
            if (type.isAssignableFrom(BundleManager.class)) {
                result = this.getBundleManager();
            } else if (type.isAssignableFrom(XEnvironment.class)) {
                result = this.getFrameworkState().getEnvironment();
            }
        }
        return result;
    }

    public boolean isFragment() {
        return false;
    }

    @Override
    boolean isSingleton() {
        return true;
    }

    @Override
    SystemBundleRevision getBundleRevisionById(int revisionId) {
        assert (revisionId == 0) : "System bundle does not have a revision with id: " + revisionId;
        return this.systemRevision;
    }

    @Override
    void startInternal(int options) throws BundleException {
    }

    @Override
    void stopInternal(int options) throws BundleException {
        this.getBundleManager().shutdownManager(false);
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
    }

    @Override
    void uninstallInternal() throws BundleException {
        throw FrameworkMessages.MESSAGES.cannotUninstallSystemBundle();
    }
}

