/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleProtocolHandler;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactory;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactoryDelegate;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactory;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactoryDelegate;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactoryService;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;
import org.osgi.util.tracker.ServiceTracker;

final class URLHandlerPlugin
extends AbstractIntegrationService<URLHandlerPlugin>
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private final InjectedValue<BundleManagerPlugin> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private ServiceTracker streamServiceTracker;
    private ServiceTracker contentServiceTracker;
    private ServiceRegistration registration;
    private static OSGiContentHandlerFactoryDelegate contentHandlerDelegate;
    private static OSGiStreamHandlerFactoryDelegate streamHandlerDelegate;

    static void initURLHandlerPlugin() {
        if (streamHandlerDelegate == null) {
            streamHandlerDelegate = new OSGiStreamHandlerFactoryDelegate();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        URL.setURLStreamHandlerFactory(streamHandlerDelegate);
                    }
                    catch (Throwable th) {
                        FrameworkLogger.LOGGER.debugf("Unable to set the URLStreamHandlerFactory", new Object[0]);
                    }
                    return null;
                }
            });
        }
        if (contentHandlerDelegate == null) {
            contentHandlerDelegate = new OSGiContentHandlerFactoryDelegate();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        URLConnection.setContentHandlerFactory(contentHandlerDelegate);
                    }
                    catch (Throwable th) {
                        FrameworkLogger.LOGGER.debugf("Unable to set the ContentHandlerFactory", new Object[0]);
                    }
                    return null;
                }
            });
        }
    }

    URLHandlerPlugin() {
        super(InternalServices.URL_HANDLER_PLUGIN);
        URLHandlerPlugin.initURLHandlerPlugin();
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<URLHandlerPlugin> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerPlugin.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public void start(StartContext context) throws StartException {
        OSGiStreamHandlerFactoryService.setDelegateFactory(this);
        streamHandlerDelegate.setDelegateFactory(new OSGiStreamHandlerFactory(this));
        contentHandlerDelegate.setDelegateFactory(new OSGiContentHandlerFactory(this));
        this.registerStreamHandlerService();
        this.setupStreamHandlerTracker();
        this.setupContentHandlerTracker();
    }

    public void stop(StopContext context) {
        streamHandlerDelegate.clearHandlers();
        contentHandlerDelegate.clearHandlers();
        this.registration.unregister();
        streamHandlerDelegate.setDelegateFactory(null);
        contentHandlerDelegate.setDelegateFactory(null);
        OSGiStreamHandlerFactoryService.setDelegateFactory(null);
    }

    public URLHandlerPlugin getValue() {
        return this;
    }

    private void registerStreamHandlerService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", "bundle");
        BundleManagerPlugin bundleManager = (BundleManagerPlugin)this.injectedBundleManager.getValue();
        BundleProtocolHandler service = new BundleProtocolHandler(bundleManager);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(URLStreamHandlerService.class.getName(), (Object)service, props);
    }

    private void setupContentHandlerTracker() {
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.contentServiceTracker = new ServiceTracker(systemContext, ContentHandler.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object service = super.addingService(reference);
                String[] mimeTypes = URLHandlerPlugin.this.parseServiceProperty(reference.getProperty("url.content.mimetype"));
                if (mimeTypes != null && service instanceof ContentHandler) {
                    FrameworkLogger.LOGGER.debugf("Adding content handler '%s' for: %s", service, Arrays.asList(mimeTypes));
                    for (String mimeType : mimeTypes) {
                        contentHandlerDelegate.addHandler(mimeType, reference);
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                contentHandlerDelegate.removeHandler(reference);
            }
        };
        this.contentServiceTracker.open();
    }

    private void setupStreamHandlerTracker() {
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.streamServiceTracker = new ServiceTracker(systemContext, URLStreamHandlerService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object service = super.addingService(reference);
                String[] protocols = URLHandlerPlugin.this.parseServiceProperty(reference.getProperty("url.handler.protocol"));
                if (protocols != null && service instanceof URLStreamHandlerService) {
                    FrameworkLogger.LOGGER.tracef("Adding stream handler '%s' for: %s", service, Arrays.asList(protocols));
                    for (String protocol : protocols) {
                        streamHandlerDelegate.addHandler(protocol, reference);
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                streamHandlerDelegate.removeHandler(reference);
            }
        };
        this.streamServiceTracker.open();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        List<ServiceReference> refList = streamHandlerDelegate.getStreamHandlers(protocol);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        return new URLStreamHandlerProxy(protocol, refList);
    }

    @Override
    public ContentHandler createContentHandler(String mimetype) {
        List<ServiceReference> refList = contentHandlerDelegate.getContentHandlers(mimetype);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        ServiceReference ref = refList.get(0);
        Object service = ref.getBundle().getBundleContext().getService(ref);
        if (service instanceof ContentHandler) {
            return (ContentHandler)service;
        }
        return null;
    }

    private String[] parseServiceProperty(Object prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof String) {
            return new String[]{(String)prop};
        }
        if (prop instanceof String[]) {
            return (String[])prop;
        }
        return null;
    }

    private static final class URLStreamHandlerProxy
    extends URLStreamHandler
    implements URLStreamHandlerSetter {
        private final List<ServiceReference> serviceReferences;
        private final String protocol;

        public URLStreamHandlerProxy(String protocol, List<ServiceReference> refList) {
            this.protocol = protocol;
            this.serviceReferences = refList;
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            super.setURL(u, protocol, host, port, file, ref);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            this.getHandlerService().parseURL((URLStreamHandlerSetter)this, u, spec, start, limit);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return this.getHandlerService().openConnection(u);
        }

        @Override
        protected String toExternalForm(URL u) {
            return this.getHandlerService().toExternalForm(u);
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            URLStreamHandlerService handler = this.getHandlerService();
            try {
                Method method = handler.getClass().getDeclaredMethod("openConnection", URL.class, Proxy.class);
                return (URLConnection)method.invoke((Object)handler, u, p);
            }
            catch (Throwable th) {
                if (th instanceof InvocationTargetException) {
                    th = ((InvocationTargetException)th).getTargetException();
                }
                throw FrameworkMessages.MESSAGES.cannotOpenConnectionOnHandler(th, handler);
            }
        }

        @Override
        protected int getDefaultPort() {
            return this.getHandlerService().getDefaultPort();
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return this.getHandlerService().equals(u1, u2);
        }

        @Override
        protected int hashCode(URL u) {
            return this.getHandlerService().hashCode(u);
        }

        @Override
        protected boolean sameFile(URL u1, URL u2) {
            return this.getHandlerService().sameFile(u1, u2);
        }

        @Override
        protected synchronized InetAddress getHostAddress(URL u) {
            return this.getHandlerService().getHostAddress(u);
        }

        @Override
        protected boolean hostsEqual(URL u1, URL u2) {
            return this.getHandlerService().hostsEqual(u1, u2);
        }

        private URLStreamHandlerService getHandlerService() {
            if (this.serviceReferences.isEmpty()) {
                throw FrameworkMessages.MESSAGES.illegalStateNoStreamHandlersForProtocol(this.protocol);
            }
            ServiceReference ref = this.serviceReferences.get(0);
            Object service = ref.getBundle().getBundleContext().getService(ref);
            return (URLStreamHandlerService)service;
        }
    }
}

